/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.Filterable;
import prompto.intrinsic.IterableWithCounts;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.IterableType;
import prompto.type.ListType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.value.IFilterable;
import prompto.value.IValue;

public class FilteredExpression
extends Section
implements IExpression {
    Identifier itemId;
    IExpression source;
    IExpression predicate;

    public FilteredExpression(Identifier itemName, IExpression source, IExpression predicate) {
        this.itemId = itemName;
        this.source = source;
        this.predicate = predicate;
    }

    public void setSource(IExpression source) {
        this.source = source;
    }

    public String toString() {
        return this.source.toString() + " filtered with " + this.itemId + " where " + this.predicate.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.itemId != null) {
            this.toDialectExplicit(writer);
        } else if (this.predicate instanceof ArrowExpression) {
            ((ArrowExpression)this.predicate).filterToDialect(writer, this.source);
        } else {
            throw new SyntaxError("Expecting an arrow expression!");
        }
    }

    private void toDialectExplicit(CodeWriter writer) {
        writer = writer.newChildWriter();
        IType sourceType = this.source.check(writer.getContext());
        IType itemType = ((IterableType)sourceType).getItemType();
        writer.getContext().registerValue(new Variable(this.itemId, itemType));
        switch (writer.getDialect()) {
            case E: 
            case M: {
                this.source.toDialect(writer);
                writer.append(" filtered with ");
                writer.append(this.itemId);
                writer.append(" where ");
                this.predicate.toDialect(writer);
                break;
            }
            case O: {
                writer.append("filtered (");
                this.source.toDialect(writer);
                writer.append(") with (");
                writer.append(this.itemId);
                writer.append(") where (");
                this.predicate.toDialect(writer);
                writer.append(")");
            }
        }
    }

    @Override
    public IType check(Context context) {
        IType sourceType = this.source.check(context);
        if (!(sourceType instanceof IterableType)) {
            throw new SyntaxError("Expecting a cursor, list, set or tuple as data source!");
        }
        IType itemType = ((IterableType)sourceType).getItemType();
        if (this.itemId != null) {
            Context child = context.newChildContext();
            child.registerValue(new Variable(this.itemId, itemType));
            IType filterType = this.predicate.check(child);
            if (filterType != BooleanType.instance()) {
                throw new SyntaxError("Filtering expression must return a boolean!");
            }
        } else if (!(this.predicate instanceof ArrowExpression)) {
            throw new SyntaxError("Expecting a filtering expression!");
        }
        return new ListType(itemType);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IType sourceType = this.source.check(context);
        if (!(sourceType instanceof IterableType)) {
            throw new InternalError("Illegal source type: " + sourceType.getTypeName());
        }
        IType itemType = ((IterableType)sourceType).getItemType();
        IValue src = this.source.interpret(context);
        if (src == null) {
            throw new NullReferenceError();
        }
        if (!(src instanceof IFilterable)) {
            throw new InternalError("Illegal fetch source: " + this.source);
        }
        Filterable<IValue, IValue> filterable = ((IFilterable)src).getFilterable(context);
        ArrowExpression arrow = this.toArrowExpression();
        Predicate<IValue> filter = arrow.getFilter(context, itemType);
        try {
            return filterable.filter(filter);
        }
        catch (InternalError e) {
            if (e.getCause() instanceof PromptoError) {
                throw (PromptoError)e.getCause();
            }
            throw e;
        }
    }

    private ArrowExpression toArrowExpression() {
        if (this.itemId != null) {
            ArrowExpression arrow = new ArrowExpression(new IdentifierList(this.itemId), null, null);
            arrow.setExpression(this.predicate);
            return arrow;
        }
        if (this.predicate instanceof ArrowExpression) {
            return (ArrowExpression)this.predicate;
        }
        throw new SyntaxError("Not a valid filter!");
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        String innerClassName = this.compileInnerFilterClass(context, method.getClassFile());
        ResultInfo srcInfo = this.source.compile(context, method, flags);
        ClassConstant innerClass = new ClassConstant(new NamedType(innerClassName));
        method.addInstruction(Opcode.NEW, innerClass);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        Descriptor.Method proto = new Descriptor.Method(Void.TYPE);
        MethodConstant m = new MethodConstant(innerClass, "<init>", proto);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        Object resultType = srcInfo.getType();
        if (resultType == IterableWithCounts.class) {
            resultType = Iterable.class;
        }
        Descriptor.Method desc = new Descriptor.Method(new Type[]{Predicate.class, resultType});
        if (srcInfo.isInterface()) {
            InterfaceConstant i = new InterfaceConstant(new ClassConstant(srcInfo.getType()), "filter", desc);
            method.addInstruction(Opcode.INVOKEINTERFACE, i);
        } else {
            m = new MethodConstant(new ClassConstant(srcInfo.getType()), "filter", desc);
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        }
        return new ResultInfo(srcInfo.getType(), new ResultInfo.Flag[0]);
    }

    private String compileInnerFilterClass(Context context, ClassFile parentClass) {
        int innerClassIndex = 1 + parentClass.getInnerClasses().size();
        String innerClassName = parentClass.getThisClass().getType().getTypeName() + '$' + innerClassIndex;
        ClassFile classFile = new ClassFile(new NamedType(innerClassName));
        classFile.setSuperClass(new ClassConstant((Type)((Object)Object.class)));
        classFile.addInterface(new ClassConstant((Type)((Object)Predicate.class)));
        CompilerUtils.compileEmptyConstructor(classFile);
        this.compileInnerClassExpression(context, classFile);
        parentClass.addInnerClass(classFile);
        return innerClassName;
    }

    private void compileInnerClassExpression(Context context, ClassFile classFile) {
        IType paramIType = this.source.check(context).checkIterator(context);
        Type paramType = paramIType.getJavaType(context);
        this.compileInnerClassBridgeMethod(classFile, paramType);
        ArrowExpression arrow = this.toArrowExpression();
        arrow.compileFilter(context, classFile, paramIType, paramType);
    }

    private void compileInnerClassBridgeMethod(ClassFile classFile, Type paramType) {
        Descriptor.Method proto = new Descriptor.Method(new Type[]{Object.class, Boolean.TYPE});
        MethodInfo method = classFile.newMethod("test", proto);
        method.addModifier(4160);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        Identifier arg = this.itemId != null ? this.itemId : (Identifier)((ArrowExpression)this.predicate).getArgs().getFirst();
        method.registerLocal(arg.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Object.class)));
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Object.class)));
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant(paramType));
        proto = new Descriptor.Method(paramType, Boolean.TYPE);
        MethodConstant c = new MethodConstant(classFile.getThisClass(), "test", proto);
        method.addInstruction(Opcode.INVOKEVIRTUAL, c);
        method.addInstruction(Opcode.IRETURN, new IOperand[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.source.declare(transpiler);
        IType manyType = this.source.check(transpiler.getContext());
        IType itemType = ((IterableType)manyType).getItemType();
        ArrowExpression arrow = this.toArrowExpression();
        arrow.declareFilter(transpiler, itemType);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType manyType = this.source.check(transpiler.getContext());
        IType itemType = ((IterableType)manyType).getItemType();
        this.source.transpile(transpiler);
        transpiler.append(".filtered(");
        ArrowExpression arrow = this.toArrowExpression();
        arrow.transpileFilter(transpiler, itemType);
        transpiler.append(")");
        transpiler.flush();
        return false;
    }
}

