/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.EqualsExpression;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.MemberSelector;
import prompto.expression.ThisExpression;
import prompto.grammar.EqOp;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.literal.BooleanLiteral;
import prompto.param.IParameter;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.runtime.LinkedVariable;
import prompto.runtime.Variable;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.utils.CodeWriter;
import prompto.value.ClosureValue;
import prompto.value.IValue;

public class InstanceExpression
extends Section
implements IPredicateExpression {
    Identifier id;

    public InstanceExpression(Identifier name) {
        this.id = name;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.toDialect(writer, true);
    }

    public void toDialect(CodeWriter writer, boolean requireMethod) {
        if (requireMethod && this.requiresMethod(writer)) {
            writer.append("Method: ");
        }
        writer.append(this.id);
    }

    private boolean requiresMethod(CodeWriter writer) {
        if (writer.getDialect() != Dialect.E) {
            return false;
        }
        INamed o = writer.getContext().getRegistered(this.id);
        return o instanceof Context.MethodDeclarationMap;
    }

    @Override
    public IType check(Context context) {
        INamed named = context.getRegistered(this.id);
        if (named == null) {
            named = context.getRegisteredDeclaration(IDeclaration.class, this.id, true);
        }
        if (named == null) {
            context.getProblemListener().reportUnknownIdentifier(this.id, this.id.toString());
            return null;
        }
        if (named instanceof Variable || named instanceof LinkedVariable || named instanceof IParameter || named instanceof CategoryDeclaration || named instanceof AttributeDeclaration) {
            return named.getType(context);
        }
        if (named instanceof Context.MethodDeclarationMap) {
            IMethodDeclaration decl = (IMethodDeclaration)((Context.MethodDeclarationMap)named).values().iterator().next();
            return new MethodType(decl);
        }
        throw new SyntaxError(this.id + "  is not a value or method:" + named.getClass().getSimpleName());
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (context.hasValue(this.id)) {
            return context.getValue(this.id);
        }
        INamed named = context.getRegistered(this.id);
        if (named instanceof Context.MethodDeclarationMap) {
            ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)((Context.MethodDeclarationMap)named).values().iterator().next();
            MethodType type = new MethodType(decl);
            return new ClosureValue(context, type);
        }
        throw new SyntaxError("No value or method with name:" + this.id);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = this.compileLocal(context, method, flags);
        if (info != null) {
            return info;
        }
        info = this.compileRegistered(context, method, flags);
        if (info != null) {
            return info;
        }
        info = this.compileInstanceField(context, method, flags);
        if (info != null) {
            return info;
        }
        info = this.compileSingletonField(context, method, flags);
        if (info != null) {
            return info;
        }
        throw new SyntaxError("Unknown identifier: " + this.getName());
    }

    private ResultInfo compileRegistered(Context context, MethodInfo method, Flags flags) {
        INamed named = context.getRegistered(this.getId());
        if (named instanceof Context.MethodDeclarationMap) {
            ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)((Context.MethodDeclarationMap)named).values().iterator().next();
            return decl.compileMethodInstance(context, method, flags);
        }
        return null;
    }

    private ResultInfo compileSingletonField(Context context, MethodInfo method, Flags flags) {
        Context actual = context.contextForValue(this.getId());
        if (actual instanceof Context.InstanceContext) {
            IType type = ((Context.InstanceContext)actual).getInstanceType();
            return type.compileGetStaticMember(context, method, flags, this.id);
        }
        return null;
    }

    private ResultInfo compileInstanceField(Context context, MethodInfo method, Flags flags) {
        Context owner;
        StackLocal local = method.getRegisteredLocal("this");
        if (local == null) {
            return null;
        }
        Section parent = new ThisExpression();
        if (context instanceof Context.ClosureContext && (owner = context.contextForValue(this.id)) instanceof Context.InstanceContext) {
            parent = new MemberSelector((IExpression)((Object)parent), new Identifier("this$0"));
        }
        MemberSelector selector = new MemberSelector((IExpression)((Object)parent), this.id);
        return selector.compile(context, method, flags);
    }

    private ResultInfo compileLocal(Context context, MethodInfo method, Flags flags) {
        StackLocal local = method.getRegisteredLocal(this.getName());
        if (local == null) {
            return null;
        }
        ClassConstant downcastTo = null;
        if (local instanceof StackLocal.ObjectLocal) {
            downcastTo = ((StackLocal.ObjectLocal)local).getDowncastTo();
        }
        ResultInfo info = CompilerUtils.compileALOAD(method, local);
        if (downcastTo == null) {
            return info;
        }
        method.addInstruction(Opcode.CHECKCAST, downcastTo);
        return new ResultInfo(downcastTo.getType(), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        INamed named = transpiler.getContext().getRegistered(this.id);
        if (named instanceof Context.MethodDeclarationMap) {
            IMethodDeclaration decl = ((Context.MethodDeclarationMap)named).getFirst();
            if (decl.getMemberOf() != null) {
                return;
            }
            if (decl instanceof ConcreteMethodDeclaration && ((ConcreteMethodDeclaration)decl).getDeclarationOf() != null) {
                return;
            }
            decl.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        INamed named;
        Context context = transpiler.getContext().contextForValue(this.id);
        if (context instanceof Context.InstanceContext) {
            ((Context.InstanceContext)context).getInstanceType().transpileInstance(transpiler);
            transpiler.append(".");
        }
        if ((named = transpiler.getContext().getRegistered(this.id)) instanceof Context.MethodDeclarationMap) {
            transpiler.append(((Context.MethodDeclarationMap)named).getFirst().getTranspiledName(context));
            if (context instanceof Context.InstanceContext) {
                transpiler.append(".bind(");
                ((Context.InstanceContext)context).getInstanceType().transpileInstance(transpiler);
                transpiler.append(")");
            }
        } else {
            if (this.getName().equals(transpiler.getGetterName())) {
                transpiler.append("$");
            }
            transpiler.append(this.getName());
        }
        return false;
    }

    private EqualsExpression toPredicate(Context context) {
        AttributeDeclaration decl = context.findAttribute(this.id.toString());
        if (decl == null) {
            context.getProblemListener().reportUnknownIdentifier(this.id, this.id.toString());
            return null;
        }
        if (!(decl instanceof AttributeDeclaration) || decl.getType() != BooleanType.instance()) {
            context.getProblemListener().reportIllegalValue(this.id, "Expected a Boolean, got " + decl.getType().getTypeName());
            return null;
        }
        return new EqualsExpression(this, EqOp.EQUALS, new BooleanLiteral("true"));
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        EqualsExpression predicate = this.toPredicate(context);
        if (predicate != null) {
            predicate.interpretQuery(context, query, store);
        }
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        EqualsExpression predicate = this.toPredicate(context);
        if (predicate != null) {
            predicate.compileQuery(context, method, flags);
        }
    }

    @Override
    public void declareQuery(Transpiler transpiler) {
        EqualsExpression predicate = this.toPredicate(transpiler.getContext());
        if (predicate != null) {
            predicate.declareQuery(transpiler);
        }
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        EqualsExpression predicate = this.toPredicate(transpiler.getContext());
        if (predicate != null) {
            predicate.transpileQuery(transpiler, builderName);
        }
    }
}

