/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.expression.ParenthesisExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoIterable;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.statement.ReturnStatement;
import prompto.statement.UnresolvedCall;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.IteratorType;
import prompto.utils.CodeWriter;
import prompto.value.IIterable;
import prompto.value.IValue;
import prompto.value.IterableValue;

public class IteratorExpression
implements IExpression {
    Identifier id;
    IExpression source;
    IExpression expression;

    public IteratorExpression(Identifier id, IExpression source, IExpression exp) {
        this.id = id;
        this.source = source;
        this.expression = exp;
    }

    public String toString() {
        return this.expression.toString() + " for each " + this.id.toString() + " in " + this.source.toString();
    }

    @Override
    public IteratorType check(Context context) {
        IType srcType = this.source.check(context).checkIterator(context);
        Context child = context.newChildContext();
        child.registerValue(new Variable(this.id, srcType));
        IType resultType = this.expression.check(child);
        return new IteratorType(resultType);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IType srcType = this.source.check(context).checkIterator(context);
        Context child = context.newChildContext();
        child.registerValue(new Variable(this.id, srcType));
        IType resultType = this.expression.check(child);
        IValue items = this.source.interpret(context);
        IterableWithCounts<IValue> iterable = this.getIterable(context, items);
        return new IterableValue(context, this.id, srcType, iterable, this.expression, resultType);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        MethodConstant c;
        Type innerClassType = this.compileInnerClass(context, method.getClassFile());
        ClassConstant innerClass = new ClassConstant(innerClassType);
        method.addInstruction(Opcode.NEW, innerClass);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        ResultInfo srcinfo = this.source.compile(context, method, flags);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        if (srcinfo.isInterface()) {
            c = new InterfaceConstant(srcinfo.getType(), "getNativeCount", Long.TYPE);
            method.addInstruction(Opcode.INVOKEINTERFACE, c);
        } else {
            c = new MethodConstant(srcinfo.getType(), "getNativeCount", Long.TYPE);
            method.addInstruction(Opcode.INVOKEVIRTUAL, c);
        }
        Descriptor.Method proto = new Descriptor.Method(new Type[]{Iterable.class, Long.TYPE, Void.TYPE});
        MethodConstant m = new MethodConstant(innerClass, "<init>", proto);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        return new ResultInfo((Type)((Object)IterableWithCounts.class), new ResultInfo.Flag[0]);
    }

    private Type compileInnerClass(Context context, ClassFile parentClass) {
        int innerClassIndex = 1 + parentClass.getInnerClasses().size();
        String innerClassName = parentClass.getThisClass().getType().getTypeName() + '$' + innerClassIndex;
        NamedType innerClassType = new NamedType(innerClassName);
        ClassFile classFile = new ClassFile(innerClassType);
        classFile.setSuperClass(new ClassConstant((Type)((Object)PromptoIterable.class)));
        this.compileInnerClassConstructor(classFile);
        this.compileInnerClassExpression(context, classFile);
        parentClass.addInnerClass(classFile);
        return innerClassType;
    }

    private MethodInfo compileInnerClassConstructor(ClassFile classFile) {
        Descriptor.Method proto = new Descriptor.Method(new Type[]{Iterable.class, Long.TYPE, Void.TYPE});
        MethodInfo method = classFile.newMethod("<init>", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
        method.registerLocal("iterable", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Iterable.class)));
        method.registerLocal("count", IVerifierEntry.VerifierType.ITEM_Long, null);
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Iterable.class)));
        method.addInstruction(Opcode.LLOAD_2, new ClassConstant(Long.TYPE));
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", proto);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
        return method;
    }

    private void compileInnerClassExpression(Context context, ClassFile classFile) {
        IType paramIType = this.source.check(context).checkIterator(context);
        context = context.newChildContext();
        context.registerValue(new Variable(this.id, paramIType));
        Type paramType = paramIType.getJavaType(context);
        Type resultType = this.expression.check(context).getJavaType(context);
        this.compileInnerClassBridgeMethod(classFile, paramType, resultType);
        this.compileInnerClassApplyMethod(context, classFile, paramType, resultType);
    }

    private void compileInnerClassApplyMethod(Context context, ClassFile classFile, Type paramType, Type resultType) {
        Descriptor.Method proto = new Descriptor.Method(paramType, resultType);
        MethodInfo method = classFile.newMethod("apply", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        method.registerLocal(this.id.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(paramType));
        ReturnStatement stmt = new ReturnStatement(this.expression);
        stmt.compile(context, method, new Flags());
    }

    private void compileInnerClassBridgeMethod(ClassFile classFile, Type paramType, Type resultType) {
        Descriptor.Method proto = new Descriptor.Method(new Type[]{Object.class, Object.class});
        MethodInfo method = classFile.newMethod("apply", proto);
        method.addModifier(4160);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        method.registerLocal(this.id.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Object.class)));
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Object.class)));
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant(paramType));
        proto = new Descriptor.Method(paramType, resultType);
        MethodConstant c = new MethodConstant(classFile.getThisClass(), "apply", proto);
        method.addInstruction(Opcode.INVOKEVIRTUAL, c);
        method.addInstruction(Opcode.ARETURN, new ClassConstant(resultType));
    }

    private IterableWithCounts<IValue> getIterable(Context context, Object src) {
        if (src instanceof IIterable) {
            return ((IIterable)src).getIterable(context);
        }
        if (src instanceof IterableWithCounts) {
            return (IterableWithCounts)src;
        }
        throw new InternalError("Should never get there!");
    }

    @Override
    public void toDialect(CodeWriter writer) {
        IType srcType = this.source.check(writer.getContext()).checkIterator(writer.getContext());
        writer = writer.newChildWriter();
        writer.getContext().registerValue(new Variable(this.id, srcType));
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toMDialect(CodeWriter writer) {
        IExpression expression = IteratorExpression.extractFromParenthesisIfPossible(this.expression);
        expression.toDialect(writer);
        writer.append(" for each ");
        writer.append(this.id.toString());
        writer.append(" in ");
        this.source.toDialect(writer);
    }

    private void toODialect(CodeWriter writer) {
        IExpression expression = IteratorExpression.extractFromParenthesisIfPossible(this.expression);
        expression.toDialect(writer);
        writer.append(" for each ( ");
        writer.append(this.id.toString());
        writer.append(" in ");
        this.source.toDialect(writer);
        writer.append(" )");
    }

    private void toEDialect(CodeWriter writer) {
        IExpression expression = IteratorExpression.encloseInParenthesisIfRequired(this.expression);
        expression.toDialect(writer);
        writer.append(" for each ");
        writer.append(this.id.toString());
        writer.append(" in ");
        this.source.toDialect(writer);
    }

    private static IExpression encloseInParenthesisIfRequired(IExpression expression) {
        if (IteratorExpression.mustBeEnclosedInParenthesis(expression)) {
            return new ParenthesisExpression(expression);
        }
        return expression;
    }

    private static IExpression extractFromParenthesisIfPossible(IExpression expression) {
        IExpression enclosed;
        if (expression instanceof ParenthesisExpression && IteratorExpression.mustBeEnclosedInParenthesis(enclosed = ((ParenthesisExpression)expression).getExpression())) {
            return enclosed;
        }
        return expression;
    }

    private static boolean mustBeEnclosedInParenthesis(IExpression expression) {
        return expression instanceof UnresolvedCall;
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.source.declare(transpiler);
        IType sourceType = this.source.check(transpiler.getContext());
        sourceType.declareIterator(transpiler, this.id, this.expression);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType sourceType = this.source.check(transpiler.getContext());
        this.source.transpile(transpiler);
        sourceType.transpileIterator(transpiler, this.id, this.expression);
        return false;
    }
}

