/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.FieldConstant;
import prompto.compiler.Flags;
import prompto.compiler.IConstantOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.NativeGetterMethodDeclaration;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.ParenthesisExpression;
import prompto.expression.SelectorExpression;
import prompto.expression.ThisExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoAny;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoRoot;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.statement.UnresolvedCall;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.NullValue;

public class MemberSelector
extends SelectorExpression {
    Identifier id;

    public MemberSelector(Identifier id) {
        this.id = id;
    }

    public MemberSelector(IExpression parent, Identifier id) {
        super(parent);
        this.id = id;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (writer.getDialect() == Dialect.E) {
            this.toEDialect(writer);
        } else {
            this.toOMDialect(writer);
        }
    }

    void toEDialect(CodeWriter writer) {
        try {
            IType type = this.check(writer.getContext());
            if (type instanceof MethodType) {
                writer.append("Method: ");
            }
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        this.parentAndMemberToDialect(writer);
    }

    void toOMDialect(CodeWriter writer) {
        this.parentAndMemberToDialect(writer);
    }

    protected void parentAndMemberToDialect(CodeWriter writer) {
        try {
            this.resolveParent(writer.getContext());
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        if (writer.getDialect() == Dialect.E) {
            this.parentToEDialect(writer);
        } else {
            this.parentToOMDialect(writer);
        }
        writer.append(".");
        writer.append(this.id);
    }

    protected void parentToEDialect(CodeWriter writer) {
        if (this.parent instanceof UnresolvedCall) {
            writer.append('(');
            this.parent.toDialect(writer);
            writer.append(')');
        } else {
            this.parent.parentToDialect(writer);
        }
    }

    protected void parentToOMDialect(CodeWriter writer) {
        if (this.parent instanceof ParenthesisExpression && ((ParenthesisExpression)this.parent).getExpression() instanceof UnresolvedCall) {
            ((ParenthesisExpression)this.parent).getExpression().toDialect(writer);
        } else {
            this.parent.toDialect(writer);
        }
    }

    public String toString() {
        return this.parent.toString() + "." + this.id;
    }

    @Override
    public IType check(Context context) {
        if ("this$0".equals(this.id.toString())) {
            Context.InstanceContext instance = context.getClosestInstanceContext();
            return instance.getInstanceType();
        }
        IType parentType = this.checkParent(context);
        return parentType.checkMember(context, this.id);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IExpression parent = this.resolveParent(context);
        IValue instance = parent.interpret(context);
        if (instance == null || instance == NullValue.instance()) {
            throw new NullReferenceError();
        }
        return instance.getMember(context, this.id, true);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        IExpression parent = this.resolveParent(context);
        ResultInfo info = parent.compileParent(context, method, flags);
        if (info.isStatic()) {
            return this.compileStaticMember(context, method, flags, parent);
        }
        return this.compileInstanceMember(context, method, flags, info);
    }

    private ResultInfo compileStaticMember(Context context, MethodInfo method, Flags flags, IExpression parent) {
        IType type = parent.check(context);
        return type.compileGetStaticMember(context, method, flags, this.id);
    }

    private ResultInfo compileInstanceMember(Context context, MethodInfo method, Flags flags, ResultInfo info) {
        IType type = this.check(context);
        Type resultType = type.getJavaType(context);
        if (Character.class == info.getType() && "codePoint".equals(this.getName())) {
            return this.compileCharacterCodePoint(method, flags);
        }
        if (String.class == info.getType() && "count".equals(this.getName())) {
            return this.compileStringLength(method, flags);
        }
        if (PromptoAny.class == info.getType()) {
            return this.compileGetMember(context, method, flags, info, resultType);
        }
        if (this.shouldCompileToGetOrCreate(info.getType())) {
            return this.compileGetOrCreate(context, method, flags, info, resultType);
        }
        if (this.shouldCompileToObjectToString(context, this.parent)) {
            return this.compileObjectToString(method, flags);
        }
        String getterName = CompilerUtils.getterName(this.getName());
        if ("getCategory".contentEquals(getterName)) {
            this.compileGetCategory(context, method, flags);
        } else if (this.isCompilingGetter(context, method, info, getterName)) {
            this.compileGetField(context, method, flags, info, resultType);
        } else if (context instanceof Context.ClosureContext) {
            this.compileGetField(context, method, flags, info, resultType);
        } else if (PromptoDict.Entry.class == info.getType()) {
            this.compileGenericGetter(context, method, flags, getterName, info, resultType);
        } else if (info.isNativeCategory()) {
            this.compileNativeGetter(context, method, flags, getterName, info, resultType);
        } else if (info.isInterface()) {
            this.compileInterfaceGetter(context, method, flags, getterName, info, resultType);
        } else {
            this.compileBeanGetter(context, method, flags, getterName, info, resultType);
        }
        return new ResultInfo(resultType, new ResultInfo.Flag[0]);
    }

    private boolean shouldCompileToGetOrCreate(Type type) {
        if (PromptoDocument.class != type) {
            return false;
        }
        switch (this.getName()) {
            case "count": 
            case "keys": 
            case "values": {
                return false;
            }
        }
        return true;
    }

    private boolean shouldCompileToObjectToString(Context context, IExpression parent) {
        IDeclaration decl;
        if (!"text".equals(this.getName())) {
            return false;
        }
        IType parentType = parent.check(context);
        return !(parentType instanceof CategoryType) || !((decl = ((CategoryType)parentType).getDeclaration(context)) instanceof CategoryDeclaration) || !((CategoryDeclaration)decl).hasAttribute(context, new Identifier("text"));
    }

    private void compileNativeGetter(Context context, MethodInfo method, Flags flags, String getterName, ResultInfo info, Type resultType) {
        NativeGetterMethodDeclaration getter = this.getNativeGetter(context);
        if (getter != null) {
            StackState state = method.captureStackState();
            StackLocal local = method.registerLocal("$this$", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(info.getType()));
            CompilerUtils.compileASTORE(method, local);
            context = context.newInstanceContext(getter.getMemberOf().getType(context), false).newChildContext();
            getter.compile(context, method, new Flags());
            method.unregisterLocal(local);
            method.restoreStackLocals(state);
            state = method.captureStackState();
            method.placeLabel(state);
            return;
        }
        this.compileBeanGetter(context, method, flags, getterName, info, resultType);
    }

    private NativeGetterMethodDeclaration getNativeGetter(Context context) {
        IDeclaration declaration;
        IType type = this.parent.check(context);
        IDeclaration iDeclaration = declaration = type instanceof CategoryType ? ((CategoryType)type).getDeclaration(context) : null;
        if (declaration instanceof NativeCategoryDeclaration) {
            return (NativeGetterMethodDeclaration)((NativeCategoryDeclaration)declaration).findGetter(context, this.id);
        }
        return null;
    }

    private void compileGetCategory(Context context, MethodInfo method, Flags flags) {
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoRoot.class), "getCategory", new Type[]{CategoryDeclaration.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
    }

    private void compileBeanGetter(Context context, MethodInfo method, Flags flags, String getterName, ResultInfo info, Type resultType) {
        MethodConstant oper = new MethodConstant(info.getType(), getterName, resultType);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
    }

    private void compileInterfaceGetter(Context context, MethodInfo method, Flags flags, String getterName, ResultInfo info, Type resultType) {
        InterfaceConstant oper = new InterfaceConstant(info.getType(), getterName, resultType);
        method.addInstruction(Opcode.INVOKEINTERFACE, oper);
    }

    private void compileGenericGetter(Context context, MethodInfo method, Flags flags, String getterName, ResultInfo info, Type resultType) {
        MethodConstant oper = new MethodConstant(info.getType(), getterName, new Type[]{Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant(resultType));
    }

    private ResultInfo compileGetOrCreate(Context context, MethodInfo method, Flags flags, ResultInfo info, Type resultType) {
        IConstantOperand oper = new StringConstant(this.getName());
        method.addInstruction(Opcode.LDC_W, oper);
        oper = new ClassConstant((Type)((Object)PromptoDocument.class));
        method.addInstruction(Opcode.LDC_W, oper);
        oper = new MethodConstant((Type)((Object)PromptoDocument.class), "getOrCreate", new Type[]{Object.class, Class.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)PromptoAny.class), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileGetMember(Context context, MethodInfo method, Flags flags, ResultInfo info, Type resultType) {
        IConstantOperand oper = new StringConstant(this.getName());
        method.addInstruction(Opcode.LDC_W, oper);
        oper = new MethodConstant((Type)((Object)PromptoAny.class), "getMember", new Type[]{Object.class, Object.class, Object.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)PromptoAny.class), new ResultInfo.Flag[0]);
    }

    private void compileGetField(Context context, MethodInfo method, Flags flags, ResultInfo info, Type resultType) {
        Type classType = CompilerUtils.categoryConcreteTypeFrom(info.getType().getTypeName());
        if ("this$0".equals(this.id.toString())) {
            resultType = CompilerUtils.categoryConcreteTypeFrom(resultType.getTypeName());
        }
        FieldConstant f = new FieldConstant(classType, this.id.toString(), resultType);
        method.addInstruction(Opcode.GETFIELD, f);
    }

    private boolean isCompilingGetter(Context context, MethodInfo method, ResultInfo parent, String getterName) {
        return this.parent instanceof ThisExpression && getterName.equals(method.getName().getValue());
    }

    private ResultInfo compileCharacterCodePoint(MethodInfo method, Flags flags) {
        MethodConstant oper = new MethodConstant((Type)((Object)Character.class), "charValue", Character.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.toPrimitive()) {
            return CompilerUtils.intTolong(method);
        }
        return CompilerUtils.intToLong(method);
    }

    private ResultInfo compileObjectToString(MethodInfo method, Flags flags) {
        MethodConstant oper = new MethodConstant((Type)((Object)Object.class), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileStringLength(MethodInfo method, Flags flags) {
        MethodConstant oper = new MethodConstant((Type)((Object)String.class), "length", Integer.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.toPrimitive()) {
            return CompilerUtils.intTolong(method);
        }
        return CompilerUtils.intToLong(method);
    }

    @Override
    public void declare(Transpiler transpiler) {
        IExpression parent = this.resolveParent(transpiler.getContext());
        parent.declareParent(transpiler);
        IType parentType = this.checkParent(transpiler.getContext());
        parentType.declareMember(transpiler, this.getId());
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IExpression parent = this.resolveParent(transpiler.getContext());
        parent.transpileParent(transpiler);
        transpiler.append(".");
        IType parentType = this.checkParent(transpiler.getContext());
        parentType.transpileMember(transpiler, this.getId());
        return false;
    }
}

