/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.utils.CodeWriter;
import prompto.value.ClosureValue;
import prompto.value.IValue;

public class MethodExpression
implements IExpression {
    Identifier id;

    public MethodExpression(Identifier id) {
        this.id = id;
    }

    public String toString() {
        return this.id.toString();
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (writer.getDialect() == Dialect.E) {
            writer.append("Method: ");
        }
        writer.append(this.id);
    }

    @Override
    public IType check(Context context) {
        IMethodDeclaration declaration = this.getDeclaration(context);
        if (declaration != null) {
            return new MethodType(declaration);
        }
        throw new SyntaxError("No method with name:" + this.id);
    }

    private IMethodDeclaration getDeclaration(Context context) {
        Context.MethodDeclarationMap methods = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, this.id);
        if (methods != null) {
            return (IMethodDeclaration)methods.values().iterator().next();
        }
        return null;
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (context.hasValue(this.id)) {
            return context.getValue(this.id);
        }
        INamed named = context.getRegistered(this.id);
        if (named instanceof Context.MethodDeclarationMap) {
            ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)((Context.MethodDeclarationMap)named).values().iterator().next();
            MethodType type = new MethodType(decl);
            return new ClosureValue(context, type);
        }
        throw new SyntaxError("No method with name:" + this.id);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        INamed named = context.getRegistered(this.id);
        if (named instanceof Context.MethodDeclarationMap) {
            ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)((Context.MethodDeclarationMap)named).getFirst();
            return decl.compileMethodInstance(context, method, flags);
        }
        throw new SyntaxError("No method with name:" + this.id);
    }

    @Override
    public void declare(Transpiler transpiler) {
        IMethodDeclaration decl;
        INamed named = transpiler.getContext().getRegistered(this.id);
        if (named instanceof Context.MethodDeclarationMap && (decl = ((Context.MethodDeclarationMap)named).getFirst()).getDeclarationOf() == null) {
            decl.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        INamed named = transpiler.getContext().getRegistered(this.id);
        if (named instanceof Context.MethodDeclarationMap) {
            Context context = transpiler.getContext().contextForValue(this.id);
            IMethodDeclaration decl = ((Context.MethodDeclarationMap)named).getFirst();
            if (context instanceof Context.InstanceContext) {
                ((Context.InstanceContext)context).getInstanceType().transpileInstance(transpiler);
                transpiler.append(".");
            }
            transpiler.append(decl.getTranspiledName(transpiler.getContext()));
            if (context instanceof Context.InstanceContext) {
                transpiler.append(".bind(");
                ((Context.InstanceContext)context).getInstanceType().transpileInstance(transpiler);
                transpiler.append(")");
            }
        }
        return false;
    }
}

