/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import prompto.compiler.BootstrapMethod;
import prompto.compiler.CallSiteConstant;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.InterfaceType;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodHandleConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NameAndTypeConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.declaration.BuiltInMethodDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeMethodDeclaration;
import prompto.declaration.SingletonCategoryDeclaration;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.CategorySymbol;
import prompto.expression.IExpression;
import prompto.expression.IMethodSelector;
import prompto.expression.InstanceExpression;
import prompto.expression.MemberSelector;
import prompto.expression.ThisExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.ArgumentList;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoNativeSymbol;
import prompto.java.JavaClassType;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.EnumeratedNativeType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.NativeType;
import prompto.utils.CodeWriter;
import prompto.value.IInstance;
import prompto.value.IValue;
import prompto.value.NullValue;
import prompto.value.TypeValue;

public class MethodSelector
extends MemberSelector
implements IMethodSelector {
    public MethodSelector(Identifier name) {
        super(name);
    }

    public MethodSelector(IExpression parent, Identifier id) {
        super(parent, id);
    }

    @Override
    public String toString() {
        return this.parent == null ? this.id.toString() : super.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.parent == null) {
            writer.append(this.id);
        } else {
            super.parentAndMemberToDialect(writer);
        }
    }

    public Set<IMethodDeclaration> getCandidates(Context context, boolean checkInstance) {
        INamed named = context.getRegistered(this.id);
        if (named instanceof Variable && named.getType(context) instanceof MethodType) {
            return Collections.singleton(((MethodType)named.getType(context)).getMethod());
        }
        if (this.parent == null) {
            return this.getGlobalCandidates(context);
        }
        return this.getMemberCandidates(context, checkInstance);
    }

    private Set<IMethodDeclaration> getGlobalCandidates(Context context) {
        Context.MethodDeclarationMap globals;
        Context.MethodDeclarationMap members;
        IType type;
        ConcreteCategoryDeclaration cd;
        HashSet<IMethodDeclaration> methods = new HashSet<IMethodDeclaration>();
        Context.InstanceContext instance = context.getClosestInstanceContext();
        if (instance != null && (cd = context.getRegisteredDeclaration(ConcreteCategoryDeclaration.class, (type = instance.getInstanceType()).getTypeNameId())) != null && (members = cd.getMemberMethods(context, this.id)) != null) {
            methods.addAll(members.values());
        }
        if ((globals = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, this.id)) != null) {
            methods.addAll(globals.values());
        }
        return methods;
    }

    private Set<IMethodDeclaration> getMemberCandidates(Context context, boolean checkInstance) {
        IType parentType = this.checkParentType(context, checkInstance);
        return parentType.getMemberMethods(context, this.id);
    }

    private IType checkParentType(Context context, boolean checkInstance) {
        if (checkInstance) {
            return this.checkParentInstance(context);
        }
        return this.checkParent(context);
    }

    private IType checkParentInstance(Context context) {
        IValue value;
        Identifier id = null;
        if (this.parent instanceof InstanceExpression) {
            id = ((InstanceExpression)this.parent).getId();
        } else if (this.parent instanceof UnresolvedIdentifier) {
            id = ((UnresolvedIdentifier)this.parent).getId();
        }
        if (id != null && Character.isLowerCase(id.toString().charAt(0)) && (value = context.getValue(id)) != null && value != NullValue.instance()) {
            return value.getType();
        }
        return this.checkParent(context);
    }

    public ResultInfo compileExact(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        if (this.parent != null) {
            return this.compileExactExplicitMember(context, method, flags, declaration, assignments);
        }
        if (declaration.getMemberOf() != null) {
            return this.compileExactImplicitMember(context, method, flags, declaration, assignments);
        }
        if (declaration.isAbstract()) {
            return this.compileExactAbstractInstance(context, method, flags, declaration, assignments);
        }
        if (!this.id.toString().equals(declaration.getName())) {
            return this.compileExactMethodInstance(context, method, flags, declaration, assignments);
        }
        return this.compileExactStaticMethod(context, method, flags, declaration, assignments);
    }

    public ResultInfo compileTemplate(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments, String methodName) {
        if (this.parent != null) {
            return this.compileTemplateExplicitMember(context, method, flags, declaration, assignments, methodName);
        }
        if (declaration.getMemberOf() != null) {
            return this.compileTemplateImplicitMember(context, method, flags, declaration, assignments, methodName);
        }
        if (declaration.isAbstract()) {
            return this.compileTemplateAbstractMethod(context, method, flags, declaration, assignments, methodName);
        }
        return this.compileTemplateStaticMethod(context, method, flags, declaration, assignments, methodName);
    }

    private ResultInfo compileTemplateStaticMethod(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments, String methodName) {
        declaration.compileParameters(context, method, flags, assignments);
        Type classType = method.getClassFile().getThisClass().getType();
        IType returnType = declaration.check(context, false);
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), returnType);
        MethodConstant constant = new MethodConstant(classType, methodName, descriptor);
        method.addInstruction(Opcode.INVOKESTATIC, constant);
        return new ResultInfo(returnType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileTemplateAbstractMethod(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments, String methodName) {
        throw new UnsupportedOperationException();
    }

    private ResultInfo compileTemplateImplicitMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments, String methodName) {
        throw new UnsupportedOperationException();
    }

    private ResultInfo compileTemplateExplicitMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments, String methodName) {
        throw new UnsupportedOperationException();
    }

    public ResultInfo compileDynamic(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        if (this.parent != null) {
            return this.compileDynamicExplicitMember(context, method, flags, declaration, assignments);
        }
        if (declaration.getMemberOf() != null) {
            return this.compileDynamicImplicitMember(context, method, flags, declaration, assignments);
        }
        return this.compileDynamicGlobalMethod(context, method, flags, declaration, assignments);
    }

    private ResultInfo compileDynamicGlobalMethod(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        declaration.compileParameters(context, method, flags, assignments);
        Type classType = CompilerUtils.getGlobalMethodType(declaration.getName());
        String methodName = declaration.getName();
        MethodConstant mc = new MethodConstant(classType, "bootstrap", new Type[]{MethodHandles.Lookup.class, String.class, java.lang.invoke.MethodType.class, CallSite.class});
        MethodHandleConstant mhc = new MethodHandleConstant(mc);
        BootstrapMethod bsm = new BootstrapMethod(mhc);
        method.getClassFile().addBootstrapMethod(bsm);
        IType returnType = declaration.check(context, false);
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), returnType);
        NameAndTypeConstant nameAndType = new NameAndTypeConstant(methodName, descriptor);
        CallSiteConstant constant = new CallSiteConstant(bsm, nameAndType);
        method.addInstruction(Opcode.INVOKEDYNAMIC, constant);
        return new ResultInfo(returnType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileDynamicImplicitMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        throw new UnsupportedOperationException();
    }

    private ResultInfo compileDynamicExplicitMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        throw new UnsupportedOperationException();
    }

    private ResultInfo compileExactMethodInstance(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        this.compileLoadMethodInstance(context, method, flags, declaration);
        declaration.compileParameters(context, method, flags, assignments);
        Type classType = CompilerUtils.getGlobalMethodType(declaration.getName());
        String methodName = declaration.getName();
        IType returnType = declaration.check(context, false);
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), returnType);
        InterfaceConstant constant = new InterfaceConstant(classType, methodName, descriptor);
        method.addInstruction(Opcode.INVOKEINTERFACE, constant);
        return new ResultInfo(returnType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileExactAbstractInstance(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        this.compileLoadMethodInstance(context, method, flags, declaration);
        declaration.compileParameters(context, method, flags, assignments);
        IType returnIType = declaration.check(context, false);
        InterfaceType intf = new InterfaceType(declaration.getParameters(), returnIType);
        Type classType = intf.getInterfaceType();
        String methodName = intf.getInterfaceMethodName();
        List<Type> argTypes = IntStream.range(0, declaration.getParameters().size()).mapToObj(i -> Object.class).collect(Collectors.toList());
        Descriptor.Method descriptor = new Descriptor.Method(argTypes.toArray(new Type[argTypes.size()]), (Type)(intf.isVoid() ? Void.TYPE : Object.class));
        InterfaceConstant constant = new InterfaceConstant(classType, methodName, descriptor);
        method.addInstruction(Opcode.INVOKEINTERFACE, constant);
        Type returnType = returnIType.getJavaType(context);
        if (!intf.isVoid()) {
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant(returnType));
        }
        return new ResultInfo(returnIType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private Type compileLoadMethodInstance(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration) {
        StackLocal local = method.getRegisteredLocal(this.getName());
        if (local != null) {
            CompilerUtils.compileALOAD(method, local);
            return ((StackLocal.ObjectLocal)local).getClassName().getType();
        }
        FieldInfo fieldInfo = method.getClassFile().getFieldInfo(this.getName());
        if (fieldInfo != null) {
            ClassConstant thisClass = method.getClassFile().getThisClass();
            method.addInstruction(Opcode.ALOAD_0, thisClass);
            FieldConstant field = new FieldConstant(method.getClassFile().getThisClass(), this.id.toString(), fieldInfo.getType());
            method.addInstruction(Opcode.GETFIELD, field);
            return field.getType();
        }
        throw new UnsupportedOperationException("Could not find abstract method instance " + this.getName());
    }

    private ResultInfo compileExactStaticMethod(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList arguments) {
        declaration.compileParameters(context, method, flags, arguments);
        Type classType = CompilerUtils.getGlobalMethodType(declaration.getName());
        String methodName = declaration.getName();
        IType returnType = declaration.check(context, false);
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), returnType);
        MethodConstant constant = new MethodConstant(classType, methodName, descriptor);
        method.addInstruction(Opcode.INVOKESTATIC, constant);
        return new ResultInfo(returnType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileExactImplicitMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList arguments) {
        StackLocal local = method.getRegisteredLocal("this");
        ClassConstant klass = ((StackLocal.ObjectLocal)local).getClassName();
        method.addInstruction(Opcode.ALOAD_0, klass);
        return this.compileExactInstanceMember(context, method, flags, declaration, arguments, new ResultInfo(klass.getType(), new ResultInfo.Flag[0]));
    }

    private ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList arguments, ResultInfo info) {
        declaration.compileParameters(context, method, flags, arguments);
        ClassConstant klass = new ClassConstant(info.getType());
        IType returnType = declaration.check(context, false);
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), returnType);
        if (info.isSuper()) {
            MethodConstant constant = new MethodConstant(klass, declaration.getName(), descriptor);
            method.addInstruction(Opcode.INVOKESPECIAL, constant);
        } else if (info.isInterface()) {
            InterfaceConstant constant = new InterfaceConstant(klass, declaration.getName(), descriptor);
            method.addInstruction(Opcode.INVOKEINTERFACE, constant);
        } else {
            MethodConstant constant = new MethodConstant(klass, declaration.getName(), descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
        }
        return new ResultInfo(returnType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileExactStaticMember(Context context, MethodInfo method, Flags flags, Type parent, IMethodDeclaration declaration, ArgumentList arguments) {
        ClassConstant parentClass = new ClassConstant(parent);
        declaration.compileParameters(context, method, flags, arguments);
        IType returnType = this.checkStaticMemberReturntype(context, declaration);
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), returnType);
        MethodConstant constant = new MethodConstant(parentClass, declaration.getName(), descriptor);
        method.addInstruction(Opcode.INVOKESTATIC, constant);
        return new ResultInfo(returnType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    private IType checkStaticMemberReturntype(Context context, IMethodDeclaration declaration) {
        IType returnType = declaration.check(context, false);
        if (returnType instanceof EnumeratedNativeType) {
            returnType = new JavaClassType((Type)((Object)PromptoNativeSymbol.class));
        }
        return returnType;
    }

    public ResultInfo compileExactExplicitMember(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration, ArgumentList assignments) {
        IExpression parent = this.resolveParent(context.getCallingContext());
        ResultInfo info = parent.compileParent(context.getCallingContext(), method, flags);
        if (info.isStatic()) {
            return this.compileExactStaticMember(context, method, flags, info.getType(), declaration, assignments);
        }
        if (declaration instanceof BuiltInMethodDeclaration) {
            BuiltInMethodDeclaration builtin = (BuiltInMethodDeclaration)declaration;
            if (builtin.hasCompileExactInstanceMember()) {
                return builtin.compileExactInstanceMember(context, method, flags, assignments);
            }
        } else if (declaration instanceof NativeMethodDeclaration) {
            return this.compileExactNativeMember(context, method, flags, (NativeMethodDeclaration)declaration, assignments, info);
        }
        return this.compileExactInstanceMember(context, method, flags, declaration, assignments, info);
    }

    public ResultInfo compileExactNativeMember(Context context, MethodInfo method, Flags flags, NativeMethodDeclaration declaration, ArgumentList assignments, ResultInfo info) {
        StackState state = method.captureStackState();
        ClassConstant klass = new ClassConstant(info.getType());
        StackLocal local = method.registerLocal("$this$", IVerifierEntry.VerifierType.ITEM_Object, klass);
        CompilerUtils.compileASTORE(method, local);
        context = context.newInstanceContext(declaration.getMemberOf().getType(context), false).newChildContext();
        info = declaration.compileMember(context, method, new Flags(), assignments);
        method.unregisterLocal(local);
        method.restoreStackLocals(state);
        state = method.captureStackState();
        method.placeLabel(state);
        return info;
    }

    public Context newLocalContext(Context context, IMethodDeclaration declaration) throws PromptoError {
        if (this.parent != null) {
            return this.newInstanceContext(context);
        }
        if (declaration.getMemberOf() != null) {
            return this.newLocalInstanceContext(context);
        }
        return context.newLocalContext();
    }

    public Context newLocalCheckContext(Context context, IMethodDeclaration declaration) {
        if (this.parent != null) {
            return this.newInstanceCheckContext(context);
        }
        if (declaration.getMemberOf() != null) {
            return this.newLocalInstanceContext(context);
        }
        return context.newLocalContext();
    }

    private Context newInstanceCheckContext(Context context) {
        IType type = this.parent.check(context);
        if (type instanceof CategoryType) {
            CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, type.getTypeNameId());
            context = context.newInstanceContext((CategoryType)type, decl instanceof SingletonCategoryDeclaration);
            return context.newChildContext();
        }
        if (type instanceof NativeType) {
            context = context.newBuiltInContext((NativeType)type);
            return context.newChildContext();
        }
        return context.newChildContext();
    }

    private Context newInstanceContext(Context context) throws PromptoError {
        IDeclaration decl;
        IType type;
        IValue value = this.parent.interpret(context);
        if (value == null || value == NullValue.instance()) {
            throw new NullReferenceError();
        }
        if (value instanceof TypeValue && (type = ((TypeValue)value).getValue()) instanceof CategoryType && (decl = ((CategoryType)type).getDeclaration(context)) instanceof SingletonCategoryDeclaration) {
            value = context.loadSingleton((CategoryType)type);
        }
        if (value instanceof CategorySymbol) {
            value = ((CategorySymbol)value).interpret(context);
        }
        if (value instanceof TypeValue) {
            return context.newChildContext();
        }
        if (value instanceof IInstance) {
            context = context.newInstanceContext((IInstance)value, false);
            return context.newChildContext();
        }
        context = context.newBuiltInContext(value);
        return context.newChildContext();
    }

    private Context newLocalInstanceContext(Context context) {
        Context.InstanceContext instance = context.getClosestInstanceContext();
        if (instance == null) {
            throw new SyntaxError("Not in instance context !");
        }
        context = context.newLocalContext();
        context.setParentContext(instance);
        return context;
    }

    public IExpression toInstanceExpression() {
        if (this.parent == null) {
            return new UnresolvedIdentifier(this.id);
        }
        return new MemberSelector(this.parent, this.id);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.parent != null) {
            super.transpile(transpiler);
            if (this.parent instanceof ThisExpression) {
                transpiler.append(".bind(this)");
            }
            return false;
        }
        transpiler.append(this.getName());
        return false;
    }

    public MethodSelector newFullSelector(long counter) {
        String name = this.id.toString() + "$" + counter;
        return new MethodSelector(this.parent, new Identifier(name));
    }
}

