/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.util.HashMap;
import java.util.Map;
import prompto.compiler.Flags;
import prompto.compiler.IUnaryFunction;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.IUnaryExpression;
import prompto.intrinsic.PromptoPeriod;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.PeriodType;
import prompto.utils.CodeWriter;
import prompto.value.DecimalValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.PeriodValue;

public class MinusExpression
implements IUnaryExpression {
    IExpression expression;
    static Map<Class<?>, IUnaryFunction> negators = MinusExpression.createNegators();

    public MinusExpression(IExpression expression) {
        this.expression = expression;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("-");
        this.expression.toDialect(writer);
    }

    public String toString() {
        return "-" + this.expression.toString();
    }

    @Override
    public IType check(Context context) {
        IType type = this.expression.check(context);
        if (type instanceof IntegerType || type instanceof DecimalType || type instanceof PeriodType) {
            return type;
        }
        throw new SyntaxError("Cannot reverse " + type.getTypeName());
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue val = this.expression.interpret(context);
        if (val instanceof IntegerValue) {
            return ((IntegerValue)val).negate();
        }
        if (val instanceof DecimalValue) {
            return ((DecimalValue)val).negate();
        }
        if (val instanceof PeriodValue) {
            return ((PeriodValue)val).negate();
        }
        throw new SyntaxError("Illegal: - " + val.getClass().getSimpleName());
    }

    public IExpression getExpression() {
        return this.expression;
    }

    private static Map<Class<?>, IUnaryFunction> createNegators() {
        HashMap map = new HashMap();
        map.put(Double.TYPE, DecimalType::compileNegate);
        map.put(Double.class, DecimalType::compileNegate);
        map.put(Long.TYPE, IntegerType::compileNegate);
        map.put(Long.class, IntegerType::compileNegate);
        map.put(PromptoPeriod.class, PeriodType::compileNegate);
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo val = this.expression.compile(context, method, flags);
        IUnaryFunction negator = negators.get(val.getType());
        if (negator == null) {
            System.err.println("Missing IOperatorFunction for negate " + val.getType().getTypeName());
            throw new SyntaxError("Cannot negate " + val.getType().getTypeName());
        }
        return negator.compile(context, method, flags, val);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.expression.declare(transpiler);
        IType type = this.expression.check(transpiler.getContext());
        type.declareMinus(transpiler, this.expression);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType type = this.expression.check(transpiler.getContext());
        type.transpileMinus(transpiler, this.expression);
        return false;
    }
}

