/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.util.HashMap;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperatorFunction;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.CategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.CharacterType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.TextType;
import prompto.utils.CodeWriter;
import prompto.value.IMultiplyable;
import prompto.value.IValue;

public class MultiplyExpression
implements IExpression {
    IExpression left;
    IExpression right;
    static Map<Class<?>, IOperatorFunction> multipliers = MultiplyExpression.createMultipliers();

    public MultiplyExpression(IExpression left, IExpression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.left.toDialect(writer);
        writer.append(" * ");
        this.right.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType lt = this.left.check(context);
        IType rt = this.right.check(context);
        return lt.checkMultiply(context, rt, true);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue lval = this.left.interpret(context);
        IValue rval = this.right.interpret(context);
        return lval.multiply(context, rval);
    }

    private static Map<Class<?>, IOperatorFunction> createMultipliers() {
        HashMap map = new HashMap();
        map.put(String.class, TextType::compileMultiply);
        map.put(Character.class, CharacterType::compileMultiply);
        map.put(Double.TYPE, DecimalType::compileMultiply);
        map.put(Double.class, DecimalType::compileMultiply);
        map.put(Long.TYPE, IntegerType::compileMultiply);
        map.put(Long.class, IntegerType::compileMultiply);
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo lval = this.left.compile(context, method, flags);
        IOperatorFunction multiplier = multipliers.get(lval.getType());
        if (multiplier == null && lval.getType().getTypeName().startsWith("\u03c0.\u03c7.")) {
            multiplier = CategoryDeclaration::compileMultiply;
        }
        if (multiplier != null) {
            return multiplier.compile(context, method, flags, lval, this.right);
        }
        if (IMultiplyable.class.isAssignableFrom((Class)lval.getType())) {
            return this.compileMultiplyable(context, method, lval, flags);
        }
        System.err.println("Missing IOperatorFunction for multiply " + lval.getType().getTypeName());
        throw new SyntaxError("Cannot multiply " + lval.getType().getTypeName() + " with " + this.right.check(context).getFamilyInfo(context));
    }

    private ResultInfo compileMultiplyable(Context context, MethodInfo method, ResultInfo lval, Flags flags) {
        try {
            ResultInfo rval = this.right.compile(context, method, flags);
            if (Long.class == rval.getType()) {
                CompilerUtils.LongToint(method);
            } else {
                CompilerUtils.longToint(method);
            }
            Class klass = (Class)lval.getType();
            Class<?> resultType = klass.getMethod("multiply", Integer.TYPE).getReturnType();
            MethodConstant oper = new MethodConstant(lval.getType(), "multiply", Integer.TYPE, resultType);
            method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
            return new ResultInfo(resultType, new ResultInfo.Flag[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SyntaxError(e.getMessage());
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        lt.declareMultiply(transpiler, rt, true, this.left, this.right);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        lt.transpileMultiply(transpiler, rt, true, this.left, this.right);
        return false;
    }
}

