/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.IUnaryExpression;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.BooleanValue;
import prompto.value.IValue;

public class NotExpression
implements IUnaryExpression,
IPredicateExpression,
IAssertion {
    IExpression expression;

    public NotExpression(IExpression expression) {
        this.expression = expression;
    }

    public String toString() {
        return "not " + this.expression.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.operatorToDialect(writer.getDialect()));
        this.expression.toDialect(writer);
    }

    private String operatorToDialect(Dialect dialect) {
        switch (dialect) {
            case E: 
            case M: {
                return "not ";
            }
            case O: {
                return "!";
            }
        }
        throw new RuntimeException("Unsupported: " + dialect.name());
    }

    @Override
    public IType check(Context context) {
        IType type = this.expression.check(context);
        if (!(type instanceof BooleanType)) {
            throw new SyntaxError("Cannot negate " + type.getTypeName());
        }
        return BooleanType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue val = this.expression.interpret(context);
        return this.interpret(val);
    }

    private IValue interpret(IValue val) throws PromptoError {
        if (val instanceof BooleanValue) {
            return ((BooleanValue)val).getNot();
        }
        throw new SyntaxError("Illegal: not " + val.getClass().getSimpleName());
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = this.expression.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        CompilerUtils.reverseBoolean(method);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        IValue val = this.expression.interpret(context);
        IValue result = this.interpret(val);
        if (result == BooleanValue.TRUE) {
            return true;
        }
        String expected = this.buildExpectedMessage(context, test);
        String actual = this.operatorToDialect(test.getDialect()) + val.toString();
        test.printFailedAssertion(context, expected, actual);
        return false;
    }

    private String buildExpectedMessage(Context context, TestMethodDeclaration test) {
        CodeWriter writer = new CodeWriter(test.getDialect(), context);
        this.toDialect(writer);
        return writer.toString();
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        StackState finalState = method.captureStackState();
        ResultInfo info = this.expression.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFEQ, finalListener);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        String message = this.buildExpectedMessage(context, test);
        message = test.buildFailedAssertionMessagePrefix(message);
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        method.addInstruction(Opcode.LDC, new StringConstant(this.operatorToDialect(test.getDialect())));
        MethodConstant concat = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        method.addInstruction(Opcode.LDC, new StringConstant(BooleanValue.FALSE.toString()));
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        test.compileFailure(context, method, flags);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.expression.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("!(");
        this.expression.transpile(transpiler);
        transpiler.append(")");
        return false;
    }

    @Override
    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        this.transpile(transpiler);
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        if (!(this.expression instanceof IPredicateExpression)) {
            throw new SyntaxError("Not a predicate: " + this.expression.toString());
        }
        ((IPredicateExpression)this.expression).interpretQuery(context, query, store);
        query.not();
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        if (!(this.expression instanceof IPredicateExpression)) {
            throw new SyntaxError("Not a predicate: " + this.expression.toString());
        }
        ((IPredicateExpression)this.expression).compileQuery(context, method, flags);
        InterfaceConstant m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "not", new Type[]{IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
    }

    @Override
    public void declareQuery(Transpiler transpiler) {
        this.expression.declare(transpiler);
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        this.expression.transpileQuery(transpiler, builderName);
        transpiler.append(builderName).append(".not();").newLine();
    }
}

