/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.io.IOException;
import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.InvalidResourceError;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.ResourceType;
import prompto.type.TextType;
import prompto.utils.CodeWriter;
import prompto.value.IResource;
import prompto.value.IValue;
import prompto.value.TextValue;

public class ReadAllExpression
implements IExpression {
    IExpression resource;

    public ReadAllExpression(IExpression resource) {
        this.resource = resource;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("read all from ");
        this.resource.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType sourceType = this.resource.check(context = context.newResourceContext());
        if (!(sourceType instanceof ResourceType)) {
            throw new SyntaxError("Not a readable resource!");
        }
        return TextType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue o = this.resource.interpret(context = context.newResourceContext());
        if (o == null) {
            throw new NullReferenceError();
        }
        if (!(o instanceof IResource)) {
            throw new InternalError("Illegal read source: " + o);
        }
        IResource res = (IResource)((Object)o);
        if (!res.isReadable()) {
            throw new InvalidResourceError("Not readable");
        }
        try {
            TextValue textValue = new TextValue(res.readFully());
            return textValue;
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
        finally {
            res.close();
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        context = context.newResourceContext();
        this.resource.compile(context, method, flags);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        InterfaceConstant c = new InterfaceConstant((Type)((Object)IResource.class), "readFully", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, c);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        c = new InterfaceConstant((Type)((Object)IResource.class), "close", Void.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, c);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.resource.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.resource.transpile(transpiler);
        transpiler.append(".readFully()");
        return false;
    }
}

