/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.util.HashMap;
import java.util.Map;
import prompto.compiler.Flags;
import prompto.compiler.ISlicerFunction;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.SelectorExpression;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoRange;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.type.RangeType;
import prompto.type.TextType;
import prompto.utils.CodeWriter;
import prompto.value.ISliceable;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class SliceSelector
extends SelectorExpression {
    IExpression first;
    IExpression last;
    static Map<Class<?>, ISlicerFunction> slicers = SliceSelector.createSlicers();

    public SliceSelector(IExpression first, IExpression last) {
        this.first = first;
        this.last = last;
    }

    public SliceSelector(IExpression parent, IExpression first, IExpression last) {
        super(parent);
        this.first = first;
        this.last = last;
    }

    public IExpression getFirst() {
        return this.first;
    }

    public IExpression getLast() {
        return this.last;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.parent.toDialect(writer);
        writer.append('[');
        if (this.first != null) {
            this.first.toDialect(writer);
        }
        writer.append(':');
        if (this.last != null) {
            this.last.toDialect(writer);
        }
        writer.append(']');
    }

    @Override
    public IType check(Context context) {
        IType lastType;
        IType firstType = this.first != null ? this.first.check(context) : null;
        IType iType = lastType = this.last != null ? this.last.check(context) : null;
        if (firstType != null && !(firstType instanceof IntegerType)) {
            throw new SyntaxError(firstType.toString() + " is not an integer");
        }
        if (lastType != null && !(lastType instanceof IntegerType)) {
            throw new SyntaxError(lastType.toString() + " is not an integer");
        }
        IType parentType = this.parent.check(context);
        return parentType.checkSlice(context);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue o = this.parent.interpret(context);
        if (o == null) {
            throw new NullReferenceError();
        }
        ISliceable<IValue> sliceable = o.asSliceable(context);
        if (sliceable != null) {
            IValue li;
            IValue fi;
            IValue iValue = fi = this.first != null ? this.first.interpret(context) : null;
            if (fi != null && !(fi instanceof IntegerValue)) {
                throw new SyntaxError("Illegal sliced type: " + fi);
            }
            IValue iValue2 = li = this.last != null ? this.last.interpret(context) : null;
            if (li != null && !(li instanceof IntegerValue)) {
                throw new SyntaxError("Illegal sliced type: " + li);
            }
            return sliceable.slice((IntegerValue)fi, (IntegerValue)li);
        }
        throw new SyntaxError("Illegal sliced object: " + this.parent);
    }

    private static Map<Class<?>, ISlicerFunction> createSlicers() {
        HashMap map = new HashMap();
        map.put(String.class, TextType::compileSlice);
        map.put(PromptoRange.Character.class, RangeType::compileSlice);
        map.put(PromptoRange.Date.class, RangeType::compileSlice);
        map.put(PromptoRange.Time.class, RangeType::compileSlice);
        map.put(PromptoRange.Long.class, RangeType::compileSlice);
        map.put(PromptoList.class, ListType::compileSlice);
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo pinfo = this.parent.compile(context, method, flags.withPrimitive(false));
        ISlicerFunction slicer = slicers.get(pinfo.getType());
        if (slicer == null) {
            System.err.println("Missing ISlicerFunction for slice " + pinfo.getType().getTypeName());
            throw new SyntaxError("Cannot slice " + pinfo.getType().getTypeName());
        }
        return slicer.compile(context, method, flags, pinfo, this.first, this.last);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.parent.declare(transpiler);
        IType parentType = this.parent.check(transpiler.getContext());
        parentType.declareSlice(transpiler, this.first, this.last);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.parent.transpile(transpiler);
        IType parentType = this.parent.check(transpiler.getContext());
        parentType.transpileSlice(transpiler, this.first, this.last);
        return false;
    }
}

