/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.util.Collection;
import java.util.Comparator;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.expression.IExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoList;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.ContainerType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.type.SetType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.ListValue;
import prompto.value.SetValue;

public class SortedExpression
implements IExpression {
    IExpression source;
    IExpression key;
    boolean descending;

    public SortedExpression(IExpression source, boolean descending) {
        this.source = source;
        this.descending = descending;
    }

    public SortedExpression(IExpression source, boolean descending, IExpression key) {
        this.source = source;
        this.descending = descending;
        this.key = key;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("sorted ");
        if (this.descending) {
            writer.append("descending ");
        }
        this.source.toDialect(writer);
        if (this.key != null) {
            IType type = this.source.check(writer.getContext());
            IType itemType = ((ContainerType)type).getItemType();
            CodeWriter local = this.contextualizeWriter(writer, itemType);
            local.append(" with ");
            IExpression keyExp = this.key;
            if (keyExp instanceof UnresolvedIdentifier) {
                try {
                    keyExp = ((UnresolvedIdentifier)keyExp).resolve(writer.getContext(), false, false);
                }
                catch (SyntaxError syntaxError) {
                    // empty catch block
                }
            }
            if (keyExp instanceof ArrowExpression) {
                ((ArrowExpression)keyExp).getArgs().forEach(arg -> {
                    Variable param = new Variable((Identifier)arg, itemType);
                    local.getContext().registerValue(param);
                });
                keyExp.toDialect(local);
            } else if (keyExp instanceof InstanceExpression) {
                ((InstanceExpression)keyExp).toDialect(local, false);
            } else {
                keyExp.toDialect(local);
            }
            local.append(" as key");
        }
    }

    private CodeWriter contextualizeWriter(CodeWriter writer, IType itemType) {
        if (itemType instanceof CategoryType) {
            return writer.newInstanceWriter((CategoryType)itemType);
        }
        if (itemType instanceof DocumentType) {
            return writer.newDocumentWriter();
        }
        return writer;
    }

    private void toODialect(CodeWriter writer) {
        writer.append("sorted ");
        if (this.descending) {
            writer.append("desc ");
        }
        writer.append("(");
        this.source.toDialect(writer);
        if (this.key != null) {
            IType type = this.source.check(writer.getContext());
            IType itemType = ((ContainerType)type).getItemType();
            writer = this.contextualizeWriter(writer, itemType);
            writer.append(", key = ");
            this.key.toDialect(writer);
        }
        writer.append(")");
    }

    private void toMDialect(CodeWriter writer) {
        this.toODialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType type = this.source.check(context);
        if (!(type instanceof ListType) && !(type instanceof SetType)) {
            throw new SyntaxError("Unsupported type: " + type);
        }
        return type;
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IType type = this.source.check(context);
        if (type instanceof ListType) {
            return this.interpretList(context, (ContainerType)type);
        }
        if (type instanceof SetType) {
            return this.interpretSet(context, (SetType)type);
        }
        throw new SyntaxError("Unsupported type: " + type);
    }

    private IValue interpretSet(Context context, SetType type) throws PromptoError {
        IValue value = this.source.interpret(context);
        if (value == null) {
            throw new NullReferenceError();
        }
        if (!(value instanceof SetValue)) {
            throw new InternalError("Unexpected type:" + value.getClass().getName());
        }
        IType itemType = type.getItemType();
        Comparator<? extends IValue> cmp = itemType.getComparator(context, this.key, this.descending);
        PromptoList<? extends IValue> sorted = ((SetValue)value).getItems().sortUsing(cmp);
        return new ListValue(itemType, (Collection<? extends IValue>)sorted);
    }

    private IValue interpretList(Context context, ContainerType type) throws PromptoError {
        IValue value = this.source.interpret(context);
        if (value == null) {
            throw new NullReferenceError();
        }
        if (!(value instanceof ListValue)) {
            throw new InternalError("Unexpected type:" + value.getClass().getName());
        }
        IType itemType = type.getItemType();
        Comparator<? extends IValue> cmp = itemType.getComparator(context, this.key, this.descending);
        PromptoList<? extends IValue> sorted = ((ListValue)value).getItems().sortUsing(cmp);
        return new ListValue(itemType, (Collection<? extends IValue>)sorted);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        IType type = this.source.check(context);
        ResultInfo info = this.source.compile(context, method, flags);
        IType itemType = ((ContainerType)type).getItemType();
        return itemType.compileSorted(context, method, flags, info, this.key, this.descending);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("List");
        this.source.declare(transpiler);
        IType type = this.source.check(transpiler.getContext());
        IType itemType = ((ContainerType)type).getItemType();
        itemType.declareSorted(transpiler, this.key);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType type = this.source.check(transpiler.getContext());
        this.source.transpile(transpiler);
        transpiler.append(".sorted(");
        IType itemType = ((ContainerType)type).getItemType();
        itemType.transpileSortedComparator(transpiler, this.key, this.descending);
        transpiler.append(")");
        return false;
    }
}

