/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.Symbol;
import prompto.grammar.Identifier;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.NullValue;

public class SymbolExpression
extends Section
implements IExpression {
    Identifier id;
    Symbol symbol;

    public SymbolExpression(Identifier id) {
        this.id = id;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.id);
    }

    public Symbol getSymbol(Context context) {
        if (this.symbol == null) {
            this.symbol = context.getGlobalsContext().getRegisteredSymbol(this.id, true);
        }
        return this.symbol;
    }

    @Override
    public IType check(Context context) {
        Symbol symbol = this.getSymbol(context);
        if (symbol == null) {
            context.getProblemListener().reportUnknownIdentifier(this, this.id.toString());
            return VoidType.instance();
        }
        return symbol.check(context);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        Symbol symbol = this.getSymbol(context);
        if (symbol == null) {
            context.getProblemListener().reportUnknownIdentifier(this, this.id.toString());
            return NullValue.instance();
        }
        return symbol.interpret(context);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        Symbol symbol = this.getSymbol(context);
        if (symbol == null) {
            throw new SyntaxError("Unknown symbol:" + this.id);
        }
        return symbol.compile(context, method, flags);
    }

    public Type getJavaType(Context context) {
        Symbol symbol = this.getSymbol(context);
        if (symbol == null) {
            throw new SyntaxError("Unknown symbol:" + this.id);
        }
        return symbol.getJavaType(context);
    }

    @Override
    public void declare(Transpiler transpiler) {
        Symbol symbol = this.getSymbol(transpiler.getContext());
        if (symbol == null) {
            transpiler.getContext().getProblemListener().reportUnknownIdentifier(this, this.id.toString());
        } else {
            symbol.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        Symbol symbol = this.getSymbol(transpiler.getContext());
        if (symbol == null) {
            transpiler.getContext().getProblemListener().reportUnknownIdentifier(this, this.id.toString());
            return false;
        }
        return symbol.transpile(transpiler);
    }
}

