/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.TypeMap;
import prompto.utils.CodeWriter;
import prompto.value.BooleanValue;
import prompto.value.IValue;

public class TernaryExpression
implements IExpression {
    IExpression condition;
    IExpression ifTrue;
    IExpression ifFalse;

    public TernaryExpression(IExpression condition, IExpression ifTrue, IExpression ifFalse) {
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (writer.getDialect() == Dialect.O) {
            this.condition.toDialect(writer);
            writer.append(" ? ");
            this.ifTrue.toDialect(writer);
            writer.append(" : ");
            this.ifFalse.toDialect(writer);
        } else {
            this.ifTrue.toDialect(writer);
            writer.append(" if ");
            this.condition.toDialect(writer);
            writer.append(" else ");
            this.ifFalse.toDialect(writer);
        }
    }

    @Override
    public IType check(Context context) {
        IType type = this.condition.check(context);
        if (!(type instanceof BooleanType)) {
            throw new SyntaxError("Cannot test condition on " + type.getTypeName());
        }
        IType trueType = this.ifTrue.check(context);
        IType falseType = this.ifFalse.check(context);
        TypeMap types = new TypeMap();
        types.put(trueType.getTypeNameId(), trueType);
        types.put(falseType.getTypeNameId(), falseType);
        return types.inferType(context);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue test = this.condition.interpret(context);
        if (test == BooleanValue.TRUE) {
            return this.ifTrue.interpret(context);
        }
        return this.ifFalse.interpret(context);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        StackState initialState = method.captureStackState();
        ResultInfo li = this.condition.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == li.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant branchListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(branchListener);
        method.addInstruction(Opcode.IFEQ, branchListener);
        ResultInfo result = this.ifTrue.compile(context, method, flags.withPrimitive(false));
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.GOTO, finalListener);
        method.restoreFullStackState(initialState);
        method.placeLabel(initialState);
        method.inhibitOffsetListener(branchListener);
        this.ifFalse.compile(context, method, flags.withPrimitive(false));
        method.inhibitOffsetListener(finalListener);
        StackState finalState = method.captureStackState();
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        return result;
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.condition.declare(transpiler);
        this.ifTrue.declare(transpiler);
        this.ifFalse.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("(");
        this.condition.transpile(transpiler);
        transpiler.append(" ? ");
        this.ifTrue.transpile(transpiler);
        transpiler.append(" : ");
        this.ifFalse.transpile(transpiler);
        transpiler.append(")");
        return false;
    }
}

