/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.TypeType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.TypeValue;

public class TypeExpression
implements IExpression {
    IType type;

    public TypeExpression(IType type) {
        this.type = type;
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.type.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        return new TypeType(this.type);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        return new TypeValue(this.type);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ClassConstant c = new ClassConstant(this.getCompiledType(context));
        method.addInstruction(Opcode.LDC, c);
        return new ResultInfo((Type)((Object)Class.class), new ResultInfo.Flag[0]);
    }

    @Override
    public ResultInfo compileParent(Context context, MethodInfo method, Flags flags) {
        return new ResultInfo(this.getCompiledType(context), ResultInfo.Flag.STATIC);
    }

    private NamedType getCompiledType(Context context) {
        return new NamedType(this.type.getJavaType(context).getTypeName());
    }

    public IType getType() {
        return this.type;
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.type.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.type.transpile(transpiler);
        return false;
    }
}

