/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.SingletonCategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ConstructorExpression;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.MethodSelector;
import prompto.expression.SymbolExpression;
import prompto.expression.TypeExpression;
import prompto.grammar.Identifier;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.problem.IProblemListener;
import prompto.problem.ProblemListener;
import prompto.runtime.Context;
import prompto.statement.MethodCall;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class UnresolvedIdentifier
extends Section
implements IPredicateExpression {
    Identifier id;
    IExpression resolved;

    public UnresolvedIdentifier(Identifier name) {
        this.id = name;
    }

    public IExpression getResolved() {
        return this.resolved;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        try {
            this.resolve(writer.getContext(), false, false);
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        if (this.resolved != null) {
            this.resolved.toDialect(writer);
        } else {
            writer.append(this.id);
        }
    }

    @Override
    public IType check(Context context) {
        return this.resolveAndCheck(context, false);
    }

    public IType checkMember(Context context) {
        return this.resolveAndCheck(context, true);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        this.resolveAndCheck(context, false);
        return this.resolved.interpret(context);
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        this.resolveAndCheck(context, false);
        if (!(this.resolved instanceof IPredicateExpression)) {
            throw new SyntaxError("Filtering expression must be a predicate !");
        }
        ((IPredicateExpression)this.resolved).interpretQuery(context, query, store);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        this.resolveAndCheck(context, false);
        return this.resolved.compile(context, method, flags);
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        this.resolveAndCheck(context, false);
        if (this.resolved instanceof IPredicateExpression) {
            ((IPredicateExpression)this.resolved).compileQuery(context, method, flags);
        } else {
            IPredicateExpression.super.compileQuery(context, method, flags);
        }
    }

    private IType resolveAndCheck(Context context, boolean forMember) {
        this.resolve(context, forMember, false);
        return this.resolved != null ? this.resolved.check(context) : AnyType.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpression resolve(Context context, boolean forMember, boolean updateSelectorParent) {
        if (this.resolved == null) {
            final IProblemListener saved = context.getProblemListener();
            try {
                context.setProblemListener(new ProblemListener(){

                    @Override
                    public boolean isCheckNative() {
                        return saved.isCheckNative();
                    }
                });
                this.resolved = this.doResolve(context, forMember, updateSelectorParent);
            }
            finally {
                context.setProblemListener(saved);
            }
            if (this.resolved == null) {
                context.getProblemListener().reportUnknownIdentifier(this, this.id.toString());
            } else if (this.resolved instanceof Section) {
                ((Section)((Object)this.resolved)).setFrom(this);
            }
        }
        return this.resolved;
    }

    private IExpression doResolve(Context context, boolean forMember, boolean updateSelectorParent) {
        IExpression resolved = this.resolveSymbol(context);
        if (resolved != null) {
            return resolved;
        }
        resolved = this.resolveTypeOrConstructor(context, forMember);
        if (resolved != null) {
            return resolved;
        }
        resolved = this.resolveMethodCall(context, updateSelectorParent);
        if (resolved != null) {
            return resolved;
        }
        resolved = this.resolveInstance(context);
        if (resolved != null) {
            return resolved;
        }
        return null;
    }

    private IExpression resolveTypeOrConstructor(Context context, boolean forMember) {
        if (Character.isUpperCase(this.id.toString().charAt(0))) {
            return this.resolveTypeOrConstructor(context);
        }
        return null;
    }

    private IExpression resolveTypeOrConstructor(Context context) {
        try {
            CategoryType type = new CategoryType(this.id);
            IDeclaration decl = type.getDeclaration(context);
            if (decl instanceof SingletonCategoryDeclaration || decl instanceof IEnumeratedDeclaration) {
                return new TypeExpression(type);
            }
            ConstructorExpression method = new ConstructorExpression(type, null, null, true);
            method.check(context);
            return method;
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    private IExpression resolveInstance(Context context) {
        try {
            InstanceExpression exp = new InstanceExpression(this.id);
            exp.check(context);
            return exp;
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    private IExpression resolveMethodCall(Context context, boolean updateSelectorParent) {
        if (this.id.getDialect() != Dialect.E) {
            return null;
        }
        try {
            MethodCall method = new MethodCall(new MethodSelector(this.id));
            method.setFrom(this);
            method.check(context, updateSelectorParent);
            return method;
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    private IExpression resolveSymbol(Context context) {
        if (this.id.toString().equals(this.id.toString().toUpperCase())) {
            return new SymbolExpression(this.id);
        }
        return null;
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.resolve(transpiler.getContext(), false, true);
        this.resolved.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.resolve(transpiler.getContext(), false, true);
        return this.resolved.transpile(transpiler);
    }

    @Override
    public void declareQuery(Transpiler transpiler) {
        this.resolve(transpiler.getContext(), false, true);
        this.resolved.declareQuery(transpiler);
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        this.resolve(transpiler.getContext(), false, true);
        this.resolved.transpileQuery(transpiler, builderName);
    }
}

