/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.MemberSelector;
import prompto.expression.MethodSelector;
import prompto.expression.SelectorExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.problem.IProblemListener;
import prompto.problem.ProblemListener;
import prompto.runtime.Context;
import prompto.statement.UnresolvedCall;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class UnresolvedSelector
extends SelectorExpression {
    Identifier id;
    IExpression resolved;

    public UnresolvedSelector(Identifier name) {
        this.id = name;
    }

    public IExpression getResolved() {
        return this.resolved;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    public String toString() {
        return (this.parent == null ? "" : this.parent.toString() + '.') + this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        try {
            this.resolve(writer.getContext(), false);
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        if (this.resolved != null) {
            this.resolved.toDialect(writer);
        } else {
            if (this.parent != null) {
                this.parent.toDialect(writer);
                writer.append('.');
            }
            writer.append(this.id);
        }
    }

    @Override
    public IType check(Context context) {
        return this.resolveAndCheck(context, false);
    }

    public IType checkMember(Context context) {
        return this.resolveAndCheck(context, true);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        this.resolveAndCheck(context, false);
        return this.resolved.interpret(context);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        this.resolveAndCheck(context, false);
        return this.resolved.compile(context, method, flags);
    }

    private IType resolveAndCheck(Context context, boolean forMember) {
        this.resolve(context, forMember);
        return this.resolved != null ? this.resolved.check(context) : AnyType.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpression resolve(Context context, boolean forMember) {
        if (this.resolved == null) {
            final IProblemListener saved = context.getProblemListener();
            try {
                context.setProblemListener(new ProblemListener(){

                    @Override
                    public boolean isCheckNative() {
                        return saved.isCheckNative();
                    }
                });
                this.resolved = this.tryResolveMethod(context, null);
                if (this.resolved == null) {
                    this.resolved = this.tryResolveMember(context);
                }
            }
            finally {
                context.setProblemListener(saved);
            }
            if (this.resolved == null) {
                context.getProblemListener().reportUnknownIdentifier(this, this.id.toString());
            }
        }
        return this.resolved;
    }

    private IExpression tryResolveMember(Context context) {
        try {
            MemberSelector member = new MemberSelector(this.parent, this.id);
            member.setFrom(this);
            member.check(context);
            return member;
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    public void resolveMethod(Context context, ArgumentList assignments) {
        if (this.resolved == null) {
            this.resolved = this.tryResolveMethod(context, assignments);
        }
    }

    public IExpression tryResolveMethod(Context context, ArgumentList assignments) {
        try {
            IExpression resolvedParent = this.parent;
            if (resolvedParent instanceof UnresolvedIdentifier) {
                ((UnresolvedIdentifier)resolvedParent).checkMember(context);
                resolvedParent = ((UnresolvedIdentifier)resolvedParent).getResolved();
            }
            UnresolvedCall method = new UnresolvedCall(new MethodSelector(resolvedParent, this.id), assignments);
            method.setFrom(this);
            method.check(context);
            return method;
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (this.resolved == null) {
            this.resolve(transpiler.getContext(), false);
        }
        this.resolved.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.resolved == null) {
            this.resolve(transpiler.getContext(), false);
        }
        return this.resolved.transpile(transpiler);
    }
}

