/*
 * Decompiled with CFR 0.152.
 */
package prompto.grammar;

import java.util.Optional;
import prompto.declaration.CategoryDeclaration;
import prompto.grammar.Identifier;
import prompto.literal.DictEntry;
import prompto.literal.DictEntryList;
import prompto.parser.Section;
import prompto.processor.AnnotationProcessor;
import prompto.runtime.Context;
import prompto.utils.CodeWriter;
import prompto.utils.Logger;

public class Annotation
extends Section {
    static Logger logger = new Logger();
    Identifier id;
    DictEntryList arguments;

    public Annotation(Identifier id, DictEntryList arguments) {
        this.id = id;
        this.arguments = arguments;
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean isNamed(String name) {
        return name.equals(this.id.toString());
    }

    public DictEntryList getArguments() {
        return this.arguments;
    }

    public Object getArgument(String name) {
        Optional<DictEntry> entry = this.arguments.stream().filter(arg -> arg.getKey().asText().getStorableData().equals(name)).findFirst();
        if (entry.isPresent()) {
            return entry.get().getValue();
        }
        return null;
    }

    public Object getDefaultArgument() {
        if (this.arguments != null && this.arguments.size() == 1) {
            return ((DictEntry)this.arguments.get(0)).getValue();
        }
        return null;
    }

    public void toDialect(CodeWriter writer) {
        writer.append(this.id.toString());
        if (this.arguments != null && !this.arguments.isEmpty()) {
            writer.append("(");
            this.arguments.forEach(arg -> {
                if (arg.getKey() != null) {
                    arg.getKey().toDialect(writer);
                    writer.append(" = ");
                }
                arg.getValue().toDialect(writer);
                writer.append(", ");
            });
            writer.trimLast(", ".length());
            writer.append(")");
        }
        writer.newLine();
    }

    public void processCategory(Context context, CategoryDeclaration declaration) {
        AnnotationProcessor processor = AnnotationProcessor.forId(this.id);
        if (processor != null) {
            processor.processCategory(this, context, declaration);
        } else {
            logger.warn(() -> "No processor for annotation " + this.id.toString());
            context.getProblemListener().reportUnknownAnnotation(this, this.id.toString());
        }
    }
}

