/*
 * Decompiled with CFR 0.152.
 */
package prompto.grammar;

import java.util.List;
import java.util.Set;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.expression.ConstructorExpression;
import prompto.expression.IExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.MemberSelector;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.statement.UnresolvedCall;
import prompto.transpiler.ITranspilable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.ContextualExpression;
import prompto.value.IInstance;
import prompto.value.IValue;

public class Argument {
    IParameter parameter;
    IExpression expression;

    public Argument(IParameter parameter, IExpression expression) {
        this.parameter = parameter;
        this.expression = expression;
    }

    public void setParameter(IParameter parameter) {
        this.parameter = parameter;
    }

    public IParameter getParameter() {
        return this.parameter;
    }

    public Identifier getParameterId() {
        return this.parameter == null ? null : this.parameter.getId();
    }

    public IExpression getExpression() {
        return this.expression != null ? this.expression : new InstanceExpression(this.parameter.getId());
    }

    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    public String toString() {
        if (this.parameter == null) {
            return this.expression.toString();
        }
        if (this.expression == null) {
            return this.parameter.getId().toString();
        }
        return this.parameter.getId() + " = " + this.expression.toString();
    }

    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toODialect(CodeWriter writer) {
        this.toMDialect(writer);
    }

    private void toMDialect(CodeWriter writer) {
        if (this.expression == null) {
            writer.append(this.parameter.getId());
        } else {
            if (this.parameter != null) {
                writer.append(this.parameter.getId());
                writer.append(" = ");
            }
            this.expression.toDialect(writer);
        }
    }

    private void toEDialect(CodeWriter writer) {
        if (this.expression == null) {
            writer.append(this.parameter.getId());
        } else {
            this.expression.toDialect(writer);
            if (this.parameter != null) {
                writer.append(" as ");
                writer.append(this.parameter.getId());
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)obj;
        return this.getParameter().equals(other.getParameter()) && this.getExpression().equals(other.getExpression());
    }

    public IType check(Context context) {
        IExpression expression = this.getExpression();
        INamed actual = context.getRegisteredValue(INamed.class, this.parameter.getId());
        if (actual == null) {
            IType actualType = expression.check(context);
            context.registerValue(new Variable(this.parameter.getId(), actualType));
        } else {
            IType actualType = actual.getType(context);
            IType newType = expression.check(context);
            actualType.checkAssignableFrom(context, newType);
        }
        return VoidType.instance();
    }

    public IExpression resolve(Context context, IMethodDeclaration methodDeclaration, boolean checkInstance, boolean allowDerived) throws PromptoError {
        IParameter parameter = this.findParameter(methodDeclaration);
        return this.resolve(context, parameter, checkInstance, allowDerived);
    }

    public IExpression resolve(Context context, IParameter parameter, boolean checkInstance, boolean allowDerived) throws PromptoError {
        IType actualType;
        IExpression expression = this.getExpression();
        IType requiredType = parameter.getType(context);
        boolean assignable = requiredType.isAssignableFrom(context, actualType = this.checkActualType(context, requiredType, expression, checkInstance));
        if (!assignable && allowDerived) {
            assignable = actualType.isAssignableFrom(context, requiredType);
        }
        if (!assignable && actualType instanceof CategoryType) {
            expression = new MemberSelector(expression, parameter.getId());
        }
        return expression;
    }

    public IType checkActualType(Context context, IType requiredType, IExpression expression, boolean checkInstance) {
        IValue value;
        IType actualType;
        boolean isArrow = this.isArrowExpression(requiredType, expression);
        IType iType = actualType = isArrow ? this.checkArrowExpression(context, (MethodType)requiredType, expression) : expression.check(context.getCallingContext());
        if (checkInstance && actualType instanceof CategoryType && (value = expression.interpret(context.getCallingContext())) instanceof IInstance) {
            actualType = ((IInstance)value).getType();
        }
        return actualType;
    }

    private IType checkArrowExpression(Context context, MethodType requiredType, IExpression expression) {
        context = expression instanceof ContextualExpression ? ((ContextualExpression)expression).getCalling() : context.getCallingContext();
        ArrowExpression arrow = (ArrowExpression)(expression instanceof ArrowExpression ? expression : ((ContextualExpression)expression).getExpression());
        return requiredType.checkArrowExpression(context, arrow);
    }

    private boolean isArrowExpression(IType requiredType, IExpression expression) {
        if (!(requiredType instanceof MethodType)) {
            return false;
        }
        if (expression instanceof ContextualExpression) {
            expression = ((ContextualExpression)expression).getExpression();
        }
        return expression instanceof ArrowExpression;
    }

    private IParameter findParameter(IMethodDeclaration methodDeclaration) {
        return methodDeclaration.getParameters().find(this.parameter.getId());
    }

    public Argument resolveAndCheck(Context context, ParameterList argumentList) {
        IParameter parameter = this.parameter;
        if (parameter == null) {
            if (argumentList.size() == 0) {
                throw new SyntaxError("Method has no parameter");
            }
            parameter = (IParameter)argumentList.get(0);
        } else {
            parameter = argumentList.find(this.getParameterId());
        }
        if (parameter == null) {
            throw new SyntaxError("Method has no parameter:" + this.getParameterId());
        }
        ContextualExpression expression = new ContextualExpression(context, this.getExpression());
        return new Argument(parameter, expression);
    }

    public void declare(Transpiler transpiler, IMethodDeclaration methodDeclaration) {
        if (this.expression != null && !this.declareArrowExpression(transpiler, methodDeclaration)) {
            this.expression.declare(transpiler);
        }
    }

    public void ensureDeclarationOrder(Context context, List<ITranspilable> list, Set<ITranspilable> set) {
        IExpression expression = this.expression;
        if (expression instanceof UnresolvedCall) {
            expression = ((UnresolvedCall)expression).resolve(context);
        }
        if (expression instanceof ConstructorExpression) {
            ((ConstructorExpression)expression).ensureDeclarationOrder(context, list, set);
        }
    }

    private boolean declareArrowExpression(Transpiler transpiler, IMethodDeclaration methodDeclaration) {
        boolean isArrow;
        if (this.parameter == null || methodDeclaration == null) {
            return false;
        }
        IParameter parameter = this.findParameter(methodDeclaration);
        IType requiredType = parameter.getType(transpiler.getContext());
        boolean bl = isArrow = requiredType instanceof MethodType && this.expression instanceof ArrowExpression;
        if (isArrow) {
            ((MethodType)requiredType).declareArrowExpression(transpiler, (ArrowExpression)this.expression);
            return true;
        }
        return false;
    }

    public void transpile(Transpiler transpiler, IMethodDeclaration methodDeclaration) {
        if (this.expression != null && !this.transpileArrowExpression(transpiler, methodDeclaration)) {
            this.expression.transpile(transpiler);
        }
    }

    private boolean transpileArrowExpression(Transpiler transpiler, IMethodDeclaration methodDeclaration) {
        return false;
    }
}

