/*
 * Decompiled with CFR 0.152.
 */
package prompto.grammar;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import prompto.declaration.IMethodDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.AndExpression;
import prompto.expression.IExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.Argument;
import prompto.grammar.Identifier;
import prompto.param.AttributeParameter;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.transpiler.ITranspilable;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;
import prompto.value.ContextualExpression;

public class ArgumentList
extends LinkedList<Argument> {
    private static final long serialVersionUID = 1L;

    public ArgumentList() {
    }

    public ArgumentList(Collection<Argument> arguments) {
        super(arguments);
    }

    public void checkLastAnd() {
        Identifier id;
        AndExpression and;
        Argument argument = (Argument)this.getLast();
        if (argument != null && argument.getParameter() != null && argument.getExpression() instanceof AndExpression && (and = (AndExpression)argument.getExpression()).getLeft() instanceof UnresolvedIdentifier && Character.isLowerCase((id = ((UnresolvedIdentifier)and.getLeft()).getId()).toString().charAt(0))) {
            this.removeLast();
            AttributeParameter parameter = new AttributeParameter(id);
            Argument attribute = new Argument(parameter, null);
            this.add(attribute);
            argument.setExpression(and.getRight());
            this.add(argument);
        }
    }

    public int findIndex(Identifier name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!name.equals(((Argument)this.get(i)).getParameterId())) continue;
            return i;
        }
        return -1;
    }

    public Argument find(Identifier name) {
        for (Argument argument : this) {
            if (!name.equals(argument.getParameterId())) continue;
            return argument;
        }
        return null;
    }

    public ArgumentList resolveAndCheck(Context context, IMethodDeclaration declaration) {
        ArgumentList arguments = new ArgumentList();
        for (Argument argument : this) {
            arguments.add(argument.resolveAndCheck(context, declaration.getParameters()));
        }
        return arguments;
    }

    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toEDialect(CodeWriter writer) {
        int idx = 0;
        if (this.size() > 0 && ((Argument)this.get(0)).getParameter() == null) {
            writer.append(' ');
            ((Argument)this.get(idx++)).toDialect(writer);
        }
        if (idx < this.size()) {
            writer.append(" with ");
            ((Argument)this.get(idx++)).toDialect(writer);
            writer.append(", ");
            while (idx < this.size() - 1) {
                ((Argument)this.get(idx++)).toDialect(writer);
                writer.append(", ");
            }
            writer.trimLast(2);
            if (idx < this.size()) {
                writer.append(" and ");
                ((Argument)this.get(idx++)).toDialect(writer);
            }
        }
    }

    private void toODialect(CodeWriter writer) {
        writer.append("(");
        for (Argument as : this) {
            as.toDialect(writer);
            writer.append(", ");
        }
        if (this.size() > 0) {
            writer.trimLast(2);
        }
        writer.append(")");
    }

    private void toMDialect(CodeWriter writer) {
        this.toODialect(writer);
    }

    public void declare(Transpiler transpiler, IMethodDeclaration declaration) {
        this.forEach(arg -> arg.declare(transpiler, declaration));
    }

    public void ensureDeclarationOrder(Context context, List<ITranspilable> list, Set<ITranspilable> set) {
        this.forEach(arg -> arg.ensureDeclarationOrder(context, list, set));
    }

    public ArgumentList makeArguments(Context context, IMethodDeclaration declaration) {
        IParameter parameter;
        ArgumentList original = new ArgumentList(this);
        ArgumentList resolved = new ArgumentList();
        for (int i = 0; i < declaration.getParameters().size(); ++i) {
            parameter = (IParameter)declaration.getParameters().get(i);
            Argument argument = null;
            int index = original.findIndex(parameter.getId());
            if (index < 0 && i == 0 && this.size() > 0 && ((Argument)this.get(0)).getParameter() == null) {
                index = 0;
            }
            if (index >= 0) {
                argument = (Argument)original.get(index);
                original.remove(index);
            }
            if (argument == null) {
                if (parameter.getDefaultExpression() != null) {
                    resolved.add(new Argument(parameter, parameter.getDefaultExpression()));
                    continue;
                }
                throw new SyntaxError("Missing argument:" + parameter.getName());
            }
            ContextualExpression expression = new ContextualExpression(context, argument.getExpression());
            resolved.add(new Argument(parameter, expression));
        }
        if (original.size() > 0) {
            Argument argument = (Argument)original.get(0);
            parameter = argument.getParameter();
            IExpression expression = argument.getExpression();
            String name = parameter == null ? (expression == null ? "<unknown>" : expression.toString()) : parameter.getName();
            throw new SyntaxError("Method has no argument:" + name);
        }
        return resolved;
    }
}

