/*
 * Decompiled with CFR 0.152.
 */
package prompto.grammar;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.grammar.Identifier;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.IQueryBuilder;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;

public class OrderByClause
extends Section {
    IdentifierList qualifiedName;
    boolean descending;

    public OrderByClause(IdentifierList qualifiedName, boolean descending) {
        this.qualifiedName = qualifiedName;
        this.descending = descending;
    }

    public IdentifierList getQualifiedName() {
        return this.qualifiedName;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void toDialect(CodeWriter writer) {
        for (Identifier name : this.qualifiedName) {
            writer.append(name.toString());
            writer.append(".");
        }
        writer.trimLast(1);
        if (this.descending) {
            writer.append(" descending");
        }
    }

    public void interpretQuery(Context context, IQueryBuilder q) {
        Identifier name = (Identifier)this.qualifiedName.getFirst();
        AttributeInfo info = context.findAttribute(name.toString()).getAttributeInfo(context);
        q.orderBy(info, this.isDescending());
    }

    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        Identifier name = (Identifier)this.qualifiedName.getFirst();
        AttributeInfo info = context.findAttribute(name.toString()).getAttributeInfo(context);
        CompilerUtils.compileAttributeInfo(context, method, flags, info);
        method.addInstruction(this.descending ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "orderBy", new Type[]{AttributeInfo.class, Boolean.TYPE, IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    public void declare(Transpiler transpiler) {
    }

    public void transpileQuery(Transpiler transpiler, String builderName) {
        String name = ((Identifier)this.qualifiedName.get(0)).toString();
        AttributeInfo info = transpiler.getContext().findAttribute(name).getAttributeInfo(transpiler.getContext());
        transpiler.append(builderName).append(".addOrderByClause(").append(info.toTranspiled()).append(", ").append(this.descending).append(");").newLine();
    }
}

