/*
 * Decompiled with CFR 0.152.
 */
package prompto.instance;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.NotMutableError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.ItemSelector;
import prompto.grammar.Identifier;
import prompto.instance.IAssignableInstance;
import prompto.instance.IAssignableSelector;
import prompto.intrinsic.PromptoAny;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoTuple;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IContainer;
import prompto.value.IValue;

public class ItemInstance
implements IAssignableSelector {
    IAssignableInstance parent;
    IExpression item;

    public ItemInstance(IExpression item) {
        this.item = item;
    }

    @Override
    public void setParent(IAssignableInstance parent) {
        this.parent = parent;
    }

    public IExpression getItem() {
        return this.item;
    }

    @Override
    public void toDialect(CodeWriter writer, IExpression expression) {
        this.parent.toDialect(writer, null);
        writer.append('[');
        this.item.toDialect(writer);
        writer.append(']');
    }

    @Override
    public IType checkAssignValue(Context context, IType valueType, ISection section) {
        IType itemType = this.item.check(context);
        return this.parent.checkAssignItem(context, itemType, valueType, section);
    }

    @Override
    public IType checkAssignMember(Context context, Identifier memberName, IType valueType, ISection section) {
        return AnyType.instance();
    }

    @Override
    public IType checkAssignItem(Context context, IType itemType, IType valueType, ISection section) {
        IType thisItemType = this.item.check(context);
        IType parentType = this.parent.checkAssignItem(context, thisItemType, valueType, section);
        return parentType.checkItem(context, itemType);
    }

    @Override
    public void assign(Context context, IExpression expression) throws PromptoError {
        IValue root = this.parent.interpret(context);
        if (!root.isMutable()) {
            throw new NotMutableError();
        }
        IValue idx = this.item.interpret(context);
        IValue value = expression.interpret(context);
        root.setItem(context, idx, value);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue parent = this.parent.interpret(context);
        IValue item = this.item.interpret(context);
        if (parent instanceof IContainer) {
            return ((IContainer)parent).getItem(context, item);
        }
        throw new SyntaxError("Unknown item/key: " + item.getClass().getName());
    }

    @Override
    public ResultInfo compileParent(Context context, MethodInfo method, Flags flags) {
        ResultInfo parentInfo = this.parent.compileParent(context, method, flags);
        return ItemSelector.compileGetItem(context, method, flags, parentInfo, this.item);
    }

    @Override
    public ResultInfo compileAssign(Context context, MethodInfo method, Flags flags, IExpression value) {
        ResultInfo parentInfo = this.parent.compileParent(context, method, flags);
        if (PromptoAny.class == parentInfo.getType() || PromptoDocument.class == parentInfo.getType()) {
            return this.compileAssignAny(context, method, flags, this.item, value);
        }
        if (PromptoList.class == parentInfo.getType()) {
            return this.compileAssignList(context, method, flags, this.item, value);
        }
        if (PromptoTuple.class == parentInfo.getType()) {
            return this.compileAssignTuple(context, method, flags, this.item, value);
        }
        if (PromptoDict.class == parentInfo.getType()) {
            return this.compileAssignDict(context, method, flags, this.item, value);
        }
        throw new UnsupportedOperationException("Cannot compileAssign for " + parentInfo.getType().getTypeName());
    }

    private ResultInfo compileAssignList(Context context, MethodInfo method, Flags flags, IExpression item2, IExpression value) {
        ResultInfo itemInfo = this.item.compile(context, method, flags.withPrimitive(true));
        CompilerUtils.numberToint(method, itemInfo);
        method.addInstruction(Opcode.ICONST_M1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        value.compile(context, method, flags.withPrimitive(false));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoList.class), "set", new Type[]{Integer.TYPE, Object.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private ResultInfo compileAssignTuple(Context context, MethodInfo method, Flags flags, IExpression item2, IExpression value) {
        ResultInfo itemInfo = this.item.compile(context, method, flags.withPrimitive(true));
        CompilerUtils.numberToint(method, itemInfo);
        method.addInstruction(Opcode.ICONST_M1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        value.compile(context, method, flags.withPrimitive(false));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoTuple.class), "set", new Type[]{Integer.TYPE, Object.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private ResultInfo compileAssignDict(Context context, MethodInfo method, Flags flags, IExpression item2, IExpression value) {
        this.item.compile(context, method, flags.withPrimitive(false));
        value.compile(context, method, flags.withPrimitive(false));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDict.class), "put", new Type[]{Object.class, Object.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private ResultInfo compileAssignAny(Context context, MethodInfo method, Flags flags, IExpression item, IExpression value) {
        item.compile(context, method, flags.withPrimitive(false));
        value.compile(context, method, flags.withPrimitive(false));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoAny.class), "setItem", new Type[]{Object.class, Object.class, Object.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public IType check(Context context) {
        IType parentType = this.parent.check(context);
        IType itemType = this.item.check(context);
        return parentType.checkItem(context, itemType);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.parent.declare(transpiler);
        this.item.declare(transpiler);
    }

    @Override
    public void declareAssign(Transpiler transpiler, IExpression expression) {
        this.parent.declare(transpiler);
        this.item.declare(transpiler);
        expression.declare(transpiler);
    }

    @Override
    public void transpileAssign(Transpiler transpiler, IExpression expression) {
        IType parentType = this.parent.check(transpiler.getContext());
        this.parent.transpileAssignParent(transpiler);
        parentType.transpileAssignItemValue(transpiler, this.item, expression);
    }

    @Override
    public void transpileAssignParent(Transpiler transpiler) {
        this.parent.transpileAssignParent(transpiler);
        transpiler.append(".getItem(");
        this.item.transpile(transpiler);
        transpiler.append(", true)");
    }
}

