/*
 * Decompiled with CFR 0.152.
 */
package prompto.instance;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.declaration.AttributeDeclaration;
import prompto.error.NotMutableError;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.instance.IAssignableInstance;
import prompto.instance.IAssignableSelector;
import prompto.intrinsic.IMutable;
import prompto.intrinsic.PromptoAny;
import prompto.intrinsic.PromptoDocument;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class MemberInstance
implements IAssignableSelector {
    IAssignableInstance parent;
    Identifier id;

    public MemberInstance(Identifier id) {
        this.id = id;
    }

    public String toString() {
        return this.parent.toString() + '.' + this.id.toString();
    }

    @Override
    public void setParent(IAssignableInstance parent) {
        this.parent = parent;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer, IExpression expression) {
        this.parent.toDialect(writer, null);
        writer.append(".");
        writer.append(this.id);
    }

    @Override
    public IType checkAssignValue(Context context, IType valueType, ISection section) {
        IType type = this.parent.checkAssignMember(context, this.id, valueType, section);
        type.checkAssignableFrom(context, valueType);
        return type;
    }

    @Override
    public IType checkAssignMember(Context context, Identifier memberName, IType valueType, ISection section) {
        this.parent.checkAssignMember(context, this.id, valueType, section);
        return valueType;
    }

    @Override
    public IType checkAssignItem(Context context, IType itemType, IType valueType, ISection section) {
        return AnyType.instance();
    }

    @Override
    public void assign(Context context, IExpression expression) throws PromptoError {
        IValue root = this.parent.interpret(context);
        if (!root.isMutable()) {
            throw new NotMutableError();
        }
        IValue value = expression.interpret(context);
        root.setMember(context, this.id, value);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue root = this.parent.interpret(context);
        return root.getMember(context, this.id, true);
    }

    @Override
    public ResultInfo compileParent(Context context, MethodInfo method, Flags flags) {
        ResultInfo parent = this.parent.compileParent(context, method, flags);
        if (PromptoDocument.class == parent.getType()) {
            StringConstant key = new StringConstant(this.getName());
            method.addInstruction(Opcode.LDC_W, key);
            ClassConstant klass = new ClassConstant((Type)((Object)PromptoDocument.class));
            method.addInstruction(Opcode.LDC_W, klass);
            MethodConstant oper = new MethodConstant(parent.getType(), "getOrCreate", new Type[]{Object.class, Class.class, Object.class});
            method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
            return new ResultInfo((Type)((Object)PromptoAny.class), new ResultInfo.Flag[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultInfo compileAssign(Context context, MethodInfo method, Flags flags, IExpression expression) {
        ResultInfo parent = this.parent.compileParent(context, method, flags);
        if (PromptoAny.class == parent.getType()) {
            return this.compileAssignAny(context, method, flags, expression);
        }
        if (PromptoDocument.class == parent.getType()) {
            return this.compileAssignDocument(context, method, flags, expression);
        }
        if (parent.isCategory()) {
            return this.compileAssignMember(context, method, flags, parent, expression);
        }
        throw new UnsupportedOperationException("Cannot assign item to " + parent.getType().getTypeName());
    }

    private ResultInfo compileAssignMember(Context context, MethodInfo method, Flags flags, ResultInfo parent, IExpression expression) {
        this.compileCheckMutable(context, method, flags, parent);
        return this.compileCallSetter(context, method, flags, parent, expression, this.id);
    }

    private void compileCheckMutable(Context context, MethodInfo method, Flags flags, ResultInfo parent) {
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        InterfaceConstant m = new InterfaceConstant((Type)((Object)IMutable.class), "checkMutable", Void.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
    }

    private ResultInfo compileCallSetter(Context context, MethodInfo method, Flags flags, ResultInfo parent, IExpression value, Identifier id) {
        value.compile(context, method, flags);
        FieldInfo field = context.getRegisteredDeclaration(AttributeDeclaration.class, id).toFieldInfo(context);
        String setterName = CompilerUtils.setterName(field.getName().getValue());
        if (parent.isInterface()) {
            InterfaceConstant m = new InterfaceConstant(parent.getType(), setterName, field.getType(), Void.TYPE);
            method.addInstruction(Opcode.INVOKEINTERFACE, m);
        } else {
            MethodConstant m = new MethodConstant(parent.getType(), setterName, field.getType(), Void.TYPE);
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        }
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private ResultInfo compileAssignAny(Context context, MethodInfo method, Flags flags, IExpression expression) {
        StringConstant key = new StringConstant(this.getName());
        method.addInstruction(Opcode.LDC_W, key);
        expression.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoAny.class), "setMember", new Type[]{Object.class, Object.class, Object.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private ResultInfo compileAssignDocument(Context context, MethodInfo method, Flags flags, IExpression expression) {
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant((Type)((Object)PromptoDocument.class)));
        StringConstant key = new StringConstant(this.getName());
        method.addInstruction(Opcode.LDC_W, key);
        expression.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDocument.class), "put", new Type[]{Object.class, Object.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public IType check(Context context) {
        IType parentType = this.parent.check(context);
        return parentType.checkMember(context, this.id);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.parent.declare(transpiler);
    }

    @Override
    public void declareAssign(Transpiler transpiler, IExpression expression) {
        this.parent.declare(transpiler);
        expression.declare(transpiler);
    }

    @Override
    public void transpileAssign(Transpiler transpiler, IExpression expression) {
        IType parentType = this.parent.check(transpiler.getContext());
        this.parent.transpileAssignParent(transpiler);
        parentType.transpileAssignMemberValue(transpiler, this.getName(), expression);
    }

    @Override
    public void transpileAssignParent(Transpiler transpiler) {
        IType parentType = this.parent.check(transpiler.getContext());
        this.parent.transpileAssignParent(transpiler);
        parentType.transpileAssignMember(transpiler, this.getName());
    }
}

