/*
 * Decompiled with CFR 0.152.
 */
package prompto.instance;

import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.instance.IAssignableInstance;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.CodeType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class VariableInstance
implements IAssignableInstance {
    Identifier id;

    public VariableInstance(Identifier id) {
        this.id = id;
    }

    public String toString() {
        return this.id.toString();
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    @Override
    public ResultInfo compileParent(Context context, MethodInfo method, Flags flags) {
        StackLocal local = method.getRegisteredLocal(this.id.toString());
        if (local instanceof StackLocal.ObjectLocal) {
            return CompilerUtils.compileALOAD(method, local);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultInfo compileAssign(Context context, MethodInfo method, Flags flags, IExpression expression) {
        IType type;
        Context actual = context.contextForValue(this.id);
        if (actual instanceof Context.InstanceContext && (type = ((Context.InstanceContext)actual).getInstanceType()) instanceof CategoryType) {
            return ((CategoryType)type).compileSetMember(context, method, flags, null, expression, this.id);
        }
        return this.compileAssignVariable(context, method, flags, expression);
    }

    public ResultInfo compileAssignVariable(Context context, MethodInfo method, Flags flags, IExpression expression) {
        IType valueType = expression.check(context);
        if (valueType == CodeType.instance()) {
            this.assign(context, expression);
            return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
        }
        this.checkAssignValue(context, valueType, this.id);
        ResultInfo info = expression.compile(context, method, flags);
        StackLocal local = method.registerLocal(this.id.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(info.getType()));
        CompilerUtils.compileASTORE(method, local);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public void toDialect(CodeWriter writer, IExpression expression) {
        if (expression != null) {
            try {
                IType type = expression.check(writer.getContext());
                INamed actual = writer.getContext().getRegisteredValue(INamed.class, this.id);
                if (actual == null) {
                    writer.getContext().registerValue(new Variable(this.id, type));
                }
            }
            catch (SyntaxError syntaxError) {
                // empty catch block
            }
        }
        writer.append(this.id);
    }

    @Override
    public IType checkAssignValue(Context context, IType valueType, ISection section) {
        INamed actual = context.getRegisteredValue(INamed.class, this.id);
        if (actual == null) {
            context.registerValue(new Variable(this.id, valueType));
        } else {
            IType actualType = actual.getType(context);
            actualType.checkAssignableFrom(context, valueType);
            valueType = actualType;
        }
        return valueType;
    }

    @Override
    public IType checkAssignMember(Context context, Identifier memberName, IType valueType, ISection section) {
        IType requiredType;
        INamed actual = context.getRegisteredValue(INamed.class, this.id);
        if (actual == null) {
            context.getProblemListener().reportUnknownIdentifier(this.id, this.id.toString());
            return VoidType.instance();
        }
        IType thisType = actual.getType(context);
        if (thisType == DocumentType.instance()) {
            return valueType;
        }
        if (thisType instanceof CategoryType && !((CategoryType)thisType).isMutable()) {
            context.getProblemListener().reportNotMutable(section, this.id.toString());
        }
        if ((requiredType = thisType.checkMember(context, memberName)) != null && !requiredType.isAssignableFrom(context, valueType)) {
            context.getProblemListener().reportIllegalAssignment(section, requiredType, valueType);
        }
        return valueType;
    }

    @Override
    public IType checkAssignItem(Context context, IType itemType, IType valueType, ISection section) {
        INamed actual = context.getRegisteredValue(INamed.class, this.id);
        if (actual == null) {
            throw new SyntaxError("Unknown variable:" + this.id);
        }
        IType parentType = actual.getType(context);
        return parentType.checkItem(context, itemType);
    }

    @Override
    public void assign(Context context, IExpression expression) throws PromptoError {
        IValue value = expression.interpret(context);
        if (context.getRegisteredValue(INamed.class, this.id) == null) {
            IType type = expression.check(context);
            context.registerValue(new Variable(this.id, type));
        }
        context.setValue(this.id, value);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        return context.getValue(this.id);
    }

    @Override
    public IType check(Context context) {
        INamed actual = context.getRegisteredValue(INamed.class, this.id);
        return actual.getType(context);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append(this.getName());
    }

    @Override
    public void declareAssign(Transpiler transpiler, IExpression expression) {
        Context context = transpiler.getContext();
        if (context.getRegisteredValue(INamed.class, this.getId()) == null) {
            IType valueType = expression.check(context);
            context.registerValue(new Variable(this.id, valueType));
            if (valueType == CodeType.instance()) {
                context.setValue(this.id, expression.interpret(context));
            }
        }
        expression.declare(transpiler);
    }

    @Override
    public void transpileAssign(Transpiler transpiler, IExpression expression) {
        Context context = transpiler.getContext();
        if (context.getRegisteredValue(INamed.class, this.id) == null) {
            IType type = expression.check(context);
            context.registerValue(new Variable(this.id, type));
            transpiler.append("var ");
        }
        if ((context = context.contextForValue(this.id)) instanceof Context.InstanceContext) {
            this.transpileAssignInstance(transpiler, expression, (Context.InstanceContext)context);
        } else {
            transpiler.append(this.getName());
            transpiler.append(" = ");
            expression.transpile(transpiler);
        }
    }

    private void transpileAssignInstance(Transpiler transpiler, IExpression expression, Context.InstanceContext context) {
        IType type = context.getInstanceType();
        type.transpileInstance(transpiler);
        if (type instanceof CategoryType) {
            ((CategoryType)type).transpileAssignMemberValue(transpiler, this.id.toString(), expression);
        } else {
            transpiler.append(".setMember('").append(this.getName()).append("', ");
            expression.transpile(transpiler);
            transpiler.append(")");
        }
    }

    @Override
    public void transpileAssignParent(Transpiler transpiler) {
        transpiler.append(this.getName());
    }
}

