/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.intrinsic.PromptoList;

public interface IterableWithCounts<T>
extends Iterable<T> {
    public Long getCount();

    default public long getNativeCount() {
        return this.getCount();
    }

    public Long getTotalCount();

    default public Iterable<T> filter(final Predicate<T> predicate) {
        final Iterator items = this.iterator();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T current;

                    @Override
                    public boolean hasNext() {
                        this.current = null;
                        while (items.hasNext()) {
                            this.current = items.next();
                            if (!predicate.test(this.current)) continue;
                            return true;
                        }
                        this.current = null;
                        return false;
                    }

                    @Override
                    public T next() {
                        return this.current;
                    }
                };
            }

            public String toString() {
                return StreamSupport.stream(this.spliterator(), false).map(Object::toString).collect(Collectors.toList()).toString();
            }
        };
    }

    default public PromptoList<T> toList() {
        PromptoList result = new PromptoList(false);
        for (Object item : this) {
            result.add(item);
        }
        return result;
    }
}

