/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import prompto.error.ReadWriteError;
import prompto.intrinsic.PromptoDocument;

public class PromptoBinary {
    private String mimeType;
    private byte[] bytes;

    public PromptoBinary() {
    }

    public PromptoBinary(String mimeType, byte[] bytes) {
        this.mimeType = mimeType;
        this.bytes = bytes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void populateFrom(Object value) {
        if (!(value instanceof PromptoDocument)) {
            throw new UnsupportedOperationException();
        }
        this.populateFromDocument((PromptoDocument)value);
    }

    private void populateFromDocument(PromptoDocument<String, Object> value) {
        try {
            Map<String, byte[]> datas = this.collectData(value);
            this.bytes = this.zipData(datas);
            this.mimeType = "application/zip";
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    private Map<String, byte[]> collectData(PromptoDocument<String, Object> value) throws IOException {
        HashMap<String, byte[]> binaries = new HashMap<String, byte[]>();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);
        value.toJson(generator, null, null, true, binaries);
        generator.flush();
        generator.close();
        binaries.put("value.json", output.toByteArray());
        return binaries;
    }

    private byte[] zipData(Map<String, byte[]> datas) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(output);
        for (Map.Entry<String, byte[]> part : datas.entrySet()) {
            ZipEntry entry = new ZipEntry(part.getKey());
            zip.putNextEntry(entry);
            zip.write(part.getValue());
            zip.closeEntry();
        }
        zip.close();
        return output.toByteArray();
    }
}

