/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class PromptoCallSite {
    public static CallSite bootstrap(MethodHandles.Lookup lookup, Class<?> checkParamsClass, MethodHandle[] methods, MethodType type) throws Throwable {
        return PromptoCallSite.bootstrap(lookup, checkParamsClass, Arrays.asList(methods), type);
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, Class<?> checkParamsClass, List<MethodHandle> methods, MethodType calling) throws Throwable {
        methods = methods.stream().filter(mh -> PromptoCallSite.compatibleWith(calling, mh.type())).sorted(PromptoCallSite.methodTypesComparator(false)).collect(Collectors.toList());
        MethodHandle method = PromptoCallSite.guardWithTest(lookup, checkParamsClass, methods, calling);
        return new ConstantCallSite(method);
    }

    private static MethodHandle guardWithTest(MethodHandles.Lookup lookup, Class<?> checkParamsClass, List<MethodHandle> methods, MethodType callingType) throws Throwable {
        MethodType testType = callingType.changeReturnType(Boolean.TYPE);
        Iterator<MethodHandle> iter = methods.iterator();
        MethodHandle fallback = iter.next();
        while (iter.hasNext()) {
            MethodHandle target = iter.next();
            MethodHandle test = PromptoCallSite.findCheckParamsMethod(lookup, checkParamsClass, target.type());
            fallback = MethodHandles.guardWithTest(test.asType(testType), target.asType(callingType), fallback.asType(callingType));
        }
        return fallback.asType(callingType);
    }

    private static MethodHandle findCheckParamsMethod(MethodHandles.Lookup lookup, Class<?> checkParamsClass, MethodType type) throws Throwable {
        String name = PromptoCallSite.buildTestMethodName(type);
        MethodType proto = type.changeReturnType(Boolean.TYPE);
        for (int i = 0; i < proto.parameterCount(); ++i) {
            proto = proto.changeParameterType(i, Object.class);
        }
        return lookup.findStatic(checkParamsClass, name, proto);
    }

    private static String buildTestMethodName(MethodType type) {
        StringBuilder sb = new StringBuilder();
        sb.append("checkParams");
        for (Class<?> klass : type.parameterList()) {
            sb.append(klass.getSimpleName());
        }
        return sb.toString();
    }

    private static Comparator<MethodHandle> methodTypesComparator(final boolean reverse) {
        return new Comparator<MethodHandle>(){

            @Override
            public int compare(MethodHandle mh1, MethodHandle mh2) {
                int result = PromptoCallSite.compareTypes(mh1.type(), mh2.type());
                return reverse ? -result : result;
            }
        };
    }

    private static int compareTypes(MethodType t1, MethodType t2) {
        Iterator<Class<?>> it1 = t1.parameterList().iterator();
        Iterator<Class<?>> it2 = t2.parameterList().iterator();
        while (it1.hasNext()) {
            boolean a2from1;
            boolean a1from2;
            Class<?> k2;
            if (!it2.hasNext()) {
                return 1;
            }
            Class<?> k1 = it1.next();
            if (k1 == (k2 = it2.next()) || k1.equals(k2) || (a1from2 = k1.isAssignableFrom(k2)) == (a2from1 = k2.isAssignableFrom(k1))) continue;
            if (a1from2) {
                return -1;
            }
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    private static boolean compatibleWith(MethodType required, MethodType offered) {
        if (required.equals((Object)offered)) {
            return true;
        }
        if (!((Class)required.returnType()).isAssignableFrom((Class<?>)offered.returnType())) {
            return false;
        }
        if (required.parameterCount() != offered.parameterCount()) {
            return false;
        }
        for (int i = 0; i < required.parameterCount(); ++i) {
            if (((Class)required.parameterType(i)).isAssignableFrom((Class<?>)offered.parameterType(i))) continue;
            return false;
        }
        return true;
    }
}

