/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;

public abstract class PromptoConverter {
    public static Object nodeToPrompto(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isIntegralNumber()) {
            return node.asLong();
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isArray()) {
            return PromptoConverter.nodeToPromptoList((ArrayNode)node);
        }
        if (node.isObject()) {
            return PromptoConverter.nodeToPromptoDocument((ObjectNode)node);
        }
        throw new RuntimeException("unsupported node type: " + node.getNodeType().name());
    }

    public static Object nodeToPromptoDocument(ObjectNode node) {
        PromptoDocument doc = new PromptoDocument();
        node.fields().forEachRemaining(f -> doc.put(f.getKey(), PromptoConverter.nodeToPrompto((JsonNode)f.getValue())));
        return doc;
    }

    public static PromptoList<Object> nodeToPromptoList(ArrayNode node) {
        List list = StreamSupport.stream(node.spliterator(), false).map(PromptoConverter::nodeToPrompto).collect(Collectors.toList());
        return new PromptoList<Object>(list, false);
    }
}

