/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import prompto.intrinsic.IDocumentable;
import prompto.intrinsic.PromptoPeriod;

public class PromptoDate
implements Comparable<PromptoDate>,
IDocumentable {
    LocalDate wrapped;

    public static PromptoDate parse(String text) {
        return new PromptoDate(LocalDate.parse((String)text));
    }

    public static PromptoDate fromJavaTime(long time) {
        return new PromptoDate(new LocalDate(time, DateTimeZone.UTC));
    }

    public PromptoDate(LocalDate wrapped) {
        this.wrapped = wrapped;
    }

    public PromptoDate(int year, int month, int day) {
        this.wrapped = new LocalDate(year, month, day);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PromptoDate && this.wrapped.equals((Object)((PromptoDate)obj).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    @Override
    public int compareTo(PromptoDate o) {
        return this.wrapped.compareTo((ReadablePartial)o.wrapped);
    }

    public Long getYear() {
        return this.wrapped.getYear();
    }

    public Long getMonth() {
        return this.wrapped.getMonthOfYear();
    }

    public Long getDayOfMonth() {
        return this.wrapped.getDayOfMonth();
    }

    public Long getDayOfYear() {
        return this.wrapped.getDayOfYear();
    }

    public long getNativeYear() {
        return this.wrapped.getYear();
    }

    public long getNativeMonth() {
        return this.wrapped.getMonthOfYear();
    }

    public long getNativeDayOfMonth() {
        return this.wrapped.getDayOfMonth();
    }

    public long getNativeDayOfYear() {
        return this.wrapped.getDayOfYear();
    }

    public PromptoDate plusDays(long count) {
        return new PromptoDate(this.wrapped.plusDays((int)count));
    }

    public boolean isAfter(PromptoDate value) {
        return this.wrapped.isAfter((ReadablePartial)value.wrapped);
    }

    public PromptoDate plus(PromptoPeriod period) {
        return new PromptoDate(this.wrapped.plus((ReadablePeriod)period.wrapped));
    }

    public PromptoDate minus(PromptoPeriod period) {
        return new PromptoDate(this.wrapped.minus((ReadablePeriod)period.wrapped));
    }

    public PromptoPeriod minus(PromptoDate other) {
        return new PromptoPeriod(this.getNativeYear() - other.getNativeYear(), this.getNativeMonth() - other.getNativeMonth(), 0L, this.getNativeDayOfMonth() - other.getNativeDayOfMonth(), 0L, 0L, 0L, 0L);
    }

    public long toJavaTime() {
        return this.wrapped.toDateTimeAtStartOfDay(DateTimeZone.UTC).getMillis();
    }

    public String format(String formatString) {
        return this.wrapped.toString(formatString);
    }

    @Override
    public Object toDocument() {
        return this.toString();
    }
}

