/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import prompto.intrinsic.IDocumentable;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoPeriod;
import prompto.intrinsic.PromptoTime;

public class PromptoDateTime
implements Comparable<PromptoDateTime>,
IDocumentable {
    private DateTime wrapped;

    public static PromptoDateTime parse(String text) {
        return new PromptoDateTime(DateTime.parse((String)text));
    }

    public static PromptoDateTime now() {
        return new PromptoDateTime(DateTime.now());
    }

    public PromptoDateTime(DateTime wrapped) {
        this.wrapped = wrapped;
    }

    public PromptoDateTime(int year, int month, int day, int hour, int minute, int second, int millis) {
        this.wrapped = new DateTime(year, month, day, hour, minute, second, millis);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PromptoDateTime && this.wrapped.equals((Object)((PromptoDateTime)obj).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    @Override
    public int compareTo(PromptoDateTime o) {
        return this.wrapped.compareTo((ReadableInstant)o.wrapped);
    }

    public Long getYear() {
        return this.wrapped.getYear();
    }

    public Long getMonth() {
        return this.wrapped.getMonthOfYear();
    }

    public Long getDayOfMonth() {
        return this.wrapped.getDayOfMonth();
    }

    public Long getDayOfYear() {
        return this.wrapped.getDayOfYear();
    }

    public Long getHour() {
        return this.wrapped.getHourOfDay();
    }

    public Long getMinute() {
        return this.wrapped.getMinuteOfHour();
    }

    public Long getSecond() {
        return this.wrapped.getSecondOfMinute();
    }

    public Long getMillisecond() {
        return this.wrapped.getMillisOfSecond();
    }

    public Long getTzOffset() {
        return (long)this.wrapped.getZone().toTimeZone().getRawOffset() / 1000L;
    }

    public long getNativeYear() {
        return this.wrapped.getYear();
    }

    public long getNativeMonth() {
        return this.wrapped.getMonthOfYear();
    }

    public long getNativeDayOfMonth() {
        return this.wrapped.getDayOfMonth();
    }

    public long getNativeDayOfYear() {
        return this.wrapped.getDayOfYear();
    }

    public long getNativeHour() {
        return this.wrapped.getHourOfDay();
    }

    public long getNativeMinute() {
        return this.wrapped.getMinuteOfHour();
    }

    public long getNativeSecond() {
        return this.wrapped.getSecondOfMinute();
    }

    public long getNativeMillis() {
        return this.wrapped.getMillisOfSecond();
    }

    public long getNativeTzOffset() {
        return this.wrapped.getZone().toTimeZone().getRawOffset() / 1000;
    }

    public String getTzName() {
        return this.wrapped.getZone().toTimeZone().getID();
    }

    public PromptoDate getDate() {
        return new PromptoDate(this.wrapped.toLocalDate());
    }

    public PromptoTime getTime() {
        return new PromptoTime(this.wrapped.toLocalTime());
    }

    public PromptoDateTime plusDays(long count) {
        return new PromptoDateTime(this.wrapped.plusDays((int)count));
    }

    public boolean isAfter(PromptoDateTime value) {
        return this.wrapped.isAfter((ReadableInstant)value.wrapped);
    }

    public PromptoDateTime plus(PromptoPeriod value) {
        return new PromptoDateTime(this.wrapped.plus((ReadablePeriod)value.wrapped));
    }

    public PromptoDateTime minus(PromptoPeriod value) {
        return new PromptoDateTime(this.wrapped.minus((ReadablePeriod)value.wrapped));
    }

    public PromptoPeriod minus(PromptoDateTime value) {
        long millis = this.toJavaTime();
        PromptoPeriod result = new PromptoPeriod(millis -= value.toJavaTime());
        if (result.getNativeHours() > 24L) {
            result = new PromptoPeriod(0L, 0L, 0L, result.getNativeHours() / 24L, result.getNativeHours() % 24L, result.getNativeMinutes(), result.getNativeSeconds(), result.getNativeMillis());
        }
        return result;
    }

    public String format(String formatString) {
        return this.wrapped.toString(formatString);
    }

    public long toJavaTime() {
        return this.wrapped.getMillis();
    }

    public boolean isEqual(PromptoDateTime actual) {
        return this.wrapped.isEqual((ReadableInstant)actual.wrapped);
    }

    @Override
    public Object toDocument() {
        return this.toString();
    }
}

