/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import prompto.intrinsic.PromptoException;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoSet;

public class PromptoDict<K, V>
extends HashMap<K, V>
implements Iterable<Entry<K, V>> {
    boolean mutable;

    public PromptoDict(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public PromptoDict<String, String> swap() {
        PromptoDict<String, String> swapped = new PromptoDict<String, String>(true);
        for (Map.Entry kvp : this.entrySet()) {
            String key = String.valueOf(kvp.getValue());
            String value = String.valueOf(kvp.getKey());
            swapped.put(key, value);
        }
        swapped.setMutable(false);
        return swapped;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        for (Map.Entry kvp : this.entrySet()) {
            String key = kvp.getKey().toString();
            if (!key.startsWith("\"")) {
                sb.append('\"');
            }
            sb.append(key);
            if (!key.endsWith("\"")) {
                sb.append('\"');
            }
            sb.append(":");
            sb.append(kvp.getValue().toString());
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        } else {
            sb.append(":");
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return super.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (!this.mutable) {
            PromptoException.throwEnumeratedException("NOT_MUTABLE");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return super.put(key, value);
    }

    public Long getCount() {
        return this.size();
    }

    public long getNativeCount() {
        return this.size();
    }

    public boolean contains(Object item) {
        return this.containsKey(item);
    }

    public boolean containsAll(Collection<Object> items) {
        return this.keySet().containsAll(items);
    }

    public boolean containsAny(Collection<Object> items) {
        for (Object item : items) {
            if (!this.containsKey(item)) continue;
            return true;
        }
        return false;
    }

    public PromptoSet<K> getKeys() {
        PromptoSet set = new PromptoSet();
        set.addAll(this.keySet());
        return set;
    }

    public PromptoList<V> getValues() {
        return new PromptoList(this.values(), false);
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new Iterator<Entry<K, V>>(){
            Iterator<Map.Entry<K, V>> iter;
            {
                this.iter = PromptoDict.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Entry<K, V> next() {
                return new Entry(this.iter.next());
            }
        };
    }

    public static class Entry<K, V> {
        Map.Entry<K, V> entry;

        public Entry(Map.Entry<K, V> entry) {
            this.entry = entry;
        }

        public K getKey() {
            return this.entry.getKey();
        }

        public V getValue() {
            return this.entry.getValue();
        }
    }
}

