/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.intrinsic.ISerializable;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoRoot;
import prompto.intrinsic.PromptoSet;
import prompto.parser.ECleverParser;
import prompto.type.CharacterType;
import prompto.type.DocumentType;
import prompto.type.IType;

public class PromptoDocument<K, V>
extends HashMap<K, V>
implements ISerializable {
    public PromptoDocument<K, V> add(PromptoDocument<K, V> toAdd) {
        PromptoDocument<K, V> doc = new PromptoDocument<K, V>();
        doc.putAll(this);
        doc.putAll(toAdd);
        return doc;
    }

    public Long getCount() {
        return this.size();
    }

    public PromptoSet<K> getKeys() {
        PromptoSet set = new PromptoSet();
        set.addAll(this.keySet());
        return set;
    }

    public PromptoList<V> getValues() {
        return new PromptoList(this.values(), false);
    }

    public V getOrCreate(K key, Class<? extends V> autoCreate) {
        if (super.containsKey(key)) {
            return super.get(key);
        }
        if ("text".equals(key)) {
            return (V)this.toString();
        }
        if (autoCreate != null) {
            try {
                V v = autoCreate.newInstance();
                super.put(key, v);
                return v;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void toJson(JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(DocumentType.instance().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartObject();
            for (Map.Entry entry : this.entrySet()) {
                fieldName = String.valueOf(entry.getKey());
                generator.writeFieldName(fieldName);
                Object value = entry.getValue();
                if (value == null) {
                    generator.writeNull();
                    continue;
                }
                this.valueToJson(value, generator, System.identityHashCode(this), fieldName, withType, binaries);
            }
            generator.writeEndObject();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    private void valueToJson(V value, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) throws IOException {
        if (value instanceof ISerializable) {
            ((ISerializable)value).toJson(generator, instanceId, fieldName, withType, binaries);
        } else if (value instanceof Boolean) {
            generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            generator.writeNumber(((Long)value).longValue());
        } else if (value instanceof Double) {
            generator.writeNumber(((Double)value).doubleValue());
        } else if (value instanceof String) {
            generator.writeString((String)value);
        } else if (value instanceof PromptoList) {
            generator.writeStartArray();
            for (Object item : (PromptoList)value) {
                this.valueToJson(item, generator, null, null, withType, binaries);
            }
            generator.writeEndArray();
        } else if (value instanceof Character) {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(CharacterType.instance().getTypeName());
                generator.writeFieldName("value");
                generator.writeString(value.toString());
                generator.writeEndObject();
            } else {
                generator.writeString(value.toString());
            }
        } else {
            throw new UnsupportedOperationException("valueToJson for " + value.getClass().getName());
        }
    }

    public void populateFrom(Object value) {
        if (value instanceof PromptoBinary) {
            this.populateFromBinary((PromptoBinary)value);
        } else if (value instanceof PromptoRoot) {
            Object doc = ((PromptoRoot)value).toDocument();
            this.putAll(doc);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void populateFromBinary(PromptoBinary blob) {
        if (!"application/zip".equals(blob.getMimeType())) {
            throw new UnsupportedOperationException();
        }
        try {
            Map<String, byte[]> parts = PromptoDocument.readParts(blob);
            JsonNode value = PromptoDocument.readValue(parts);
            JsonNode field = value.get("type");
            if (field == null) {
                throw new InvalidParameterException("Expecting a 'type' field!");
            }
            IType type = new ECleverParser(field.asText()).parse_standalone_type();
            if (type != DocumentType.instance()) {
                throw new InvalidParameterException("Expecting a Document type!");
            }
            field = value.get("value");
            if (field == null) {
                throw new InvalidParameterException("Expecting a 'value' field!");
            }
            this.readJSONValue(field, parts);
        }
        catch (Exception e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    private void readJSONValue(JsonNode value, Map<String, byte[]> parts) {
        Iterator fields = value.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            Object item = PromptoDocument.readJSONField((JsonNode)field.getValue(), parts);
            this.put(field.getKey(), item);
        }
    }

    public static Object readJSONField(JsonNode fieldData, Map<String, byte[]> parts) throws PromptoError {
        if (fieldData == null || fieldData.isNull()) {
            return null;
        }
        if (fieldData.isBoolean()) {
            return fieldData.asBoolean();
        }
        if (fieldData.isInt() || fieldData.isLong()) {
            return new Long(fieldData.asLong());
        }
        if (fieldData.isFloat() || fieldData.isDouble()) {
            return new Double(fieldData.asDouble());
        }
        if (fieldData.isTextual()) {
            return fieldData.asText();
        }
        if (fieldData.isArray()) {
            throw new UnsupportedOperationException();
        }
        if (fieldData.isObject()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Exception decompiling
     */
    public static Map<String, byte[]> readParts(PromptoBinary blob) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JsonNode readValue(Map<String, byte[]> parts) throws IOException {
        byte[] data = parts.get("value.json");
        if (data == null) {
            throw new InvalidParameterException("Expecting a 'value.json' part!");
        }
        JsonParser parser = new ObjectMapper().getFactory().createParser(data);
        return (JsonNode)parser.readValueAsTree();
    }

    @Override
    public String toString() {
        return this.toString(this::valueToJson, false);
    }

    public String toString(ValueToJson<V> o, boolean withType) {
        try {
            HashMap<String, byte[]> binaries = new HashMap<String, byte[]>();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);
            generator.writeStartObject();
            for (Map.Entry entry : this.entrySet()) {
                generator.writeFieldName(String.valueOf(entry.getKey()));
                Object value = entry.getValue();
                if (value == null) {
                    generator.writeNull();
                    continue;
                }
                o.apply(value, generator, System.identityHashCode(this), String.valueOf(entry.getKey()), withType, binaries);
            }
            generator.writeEndObject();
            generator.flush();
            generator.close();
            return new String(output.toByteArray());
        }
        catch (Throwable t) {
            return "<error:" + t.getMessage() + ">";
        }
    }

    public static interface ValueToJson<V> {
        public void apply(V var1, JsonGenerator var2, Object var3, String var4, boolean var5, Map<String, byte[]> var6) throws IOException;
    }
}

