/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import prompto.compiler.PromptoClassLoader;

public abstract class PromptoException {
    public static String getExceptionTypeName(Object e) {
        Class<?> type = e.getClass();
        return PromptoException.getExceptionTypeName(type);
    }

    public static String getExceptionTypeName(Class<?> type) {
        if (ArithmeticException.class == type) {
            return "DIVIDE_BY_ZERO";
        }
        if (IndexOutOfBoundsException.class == type) {
            return "INDEX_OUT_OF_RANGE";
        }
        if (NullPointerException.class == type) {
            return "NULL_REFERENCE";
        }
        return type.getSimpleName();
    }

    public static Type getExceptionType(String name) {
        switch (name) {
            case "DIVIDE_BY_ZERO": {
                return ArithmeticException.class;
            }
            case "INDEX_OUT_OF_RANGE": {
                return IndexOutOfBoundsException.class;
            }
            case "NULL_REFERENCE": {
                return NullPointerException.class;
            }
        }
        return null;
    }

    public static void throwEnumeratedException(String name) {
        try {
            String exceptionName = "\u03c0.\u03b5.Error$%Error";
            PromptoClassLoader loader = PromptoClassLoader.getInstance();
            if (loader == null) {
                throw new UnsupportedOperationException("throwEnumeratedException can only be used in compiled mode!");
            }
            Class<?> klass = Class.forName(exceptionName, true, loader);
            Field field = klass.getDeclaredField(name);
            RuntimeException instance = (RuntimeException)field.get(null);
            throw instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static void throwEnumeratedException(String name, String message) {
        try {
            String exceptionName = "\u03c0.\u03b5.Error$%Error$" + name;
            PromptoClassLoader loader = PromptoClassLoader.getInstance();
            if (loader == null) {
                throw new UnsupportedOperationException("throwEnumeratedException can only be used in compiled mode!");
            }
            Class<?> klass = Class.forName(exceptionName, true, loader);
            Constructor<?> ctor = klass.getDeclaredConstructor(String.class);
            RuntimeException instance = (RuntimeException)ctor.newInstance(message);
            throw instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

