/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import prompto.intrinsic.Filterable;
import prompto.intrinsic.IDocumentable;
import prompto.intrinsic.PromptoException;
import prompto.value.IMultiplyable;

public class PromptoList<V>
extends ArrayList<V>
implements Filterable<PromptoList<V>, V>,
IMultiplyable,
IDocumentable {
    boolean mutable;

    public PromptoList(boolean mutable) {
        this.mutable = mutable;
    }

    public PromptoList(V[] items) {
        super(Arrays.asList(items));
        this.mutable = false;
    }

    public PromptoList(Collection<? extends V> items, boolean mutable) {
        super(items);
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public Long getCount() {
        return this.size();
    }

    public long getNativeCount() {
        return this.size();
    }

    @Override
    public V getLast() {
        return (V)this.get(this.size() - 1);
    }

    public PromptoList<V> multiply(int count) {
        PromptoList<V> result = new PromptoList<V>(false);
        while (count-- > 0) {
            result.addAll(this);
        }
        return result;
    }

    public PromptoList<V> slice(long first) {
        return this.slice(first, this.size());
    }

    public PromptoList<V> slice(long first, long last) {
        if (first < 0L) {
            first = (long)(this.size() + 1) + first;
        }
        if (last < 0L) {
            last = (long)(this.size() + 1) + last;
        }
        return new PromptoList(this.subList((int)(first - 1L), (int)last), false);
    }

    public PromptoList<V> sort(boolean descending) {
        PromptoList<V> sorted = new PromptoList<V>(this, false);
        Comparator cmp = descending ? (o1, o2) -> ((Comparable)o2).compareTo(o1) : (o1, o2) -> ((Comparable)o1).compareTo(o2);
        sorted.sort(cmp);
        return sorted;
    }

    public PromptoList<? extends V> sortUsing(Comparator<? extends V> cmp) {
        PromptoList<V> sorted = new PromptoList<V>(this, false);
        sorted.sort(cmp);
        return sorted;
    }

    public boolean containsAny(Collection<Object> items) {
        for (Object item : items) {
            if (!this.contains(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PromptoList<V> filter(Predicate<V> p) {
        PromptoList filtered = new PromptoList(false);
        this.forEach((? super E v) -> {
            if (p.test(v)) {
                filtered.add(v);
            }
        });
        return filtered;
    }

    @Override
    public V set(int index, V element) {
        if (!this.mutable) {
            PromptoException.throwEnumeratedException("NOT_MUTABLE");
        }
        return super.set(index, element);
    }

    public String join(String delimiter) {
        return this.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    @Override
    public PromptoList<? extends V> toDocument() {
        List items = this.stream().map(item -> {
            if (item instanceof IDocumentable) {
                return ((IDocumentable)item).toDocument();
            }
            return item;
        }).collect(Collectors.toList());
        return new PromptoList(items, false);
    }
}

