/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class PromptoMethod {
    static Map<Integer, BiFunction<Method, Object, Object>> consumerProducers = PromptoMethod.getConsumerProducers();
    static Map<Integer, BiFunction<Method, Object, Object>> supplierProducers = PromptoMethod.getSupplierProducers();

    private static Map<Integer, BiFunction<Method, Object, Object>> getConsumerProducers() {
        HashMap<Integer, BiFunction<Method, Object, Object>> result = new HashMap<Integer, BiFunction<Method, Object, Object>>();
        result.put(0, PromptoMethod::newRunnable);
        result.put(1, PromptoMethod::newConsumer);
        return result;
    }

    private static Map<Integer, BiFunction<Method, Object, Object>> getSupplierProducers() {
        HashMap<Integer, BiFunction<Method, Object, Object>> result = new HashMap<Integer, BiFunction<Method, Object, Object>>();
        result.put(1, PromptoMethod::newFunction);
        return result;
    }

    public static Object newMethodReference(Class<?> klass, String methodName, Object instance) {
        Method method = Arrays.asList(klass.getDeclaredMethods()).stream().filter(m -> methodName.equals(m.getName())).findFirst().orElse(null);
        if (method.getReturnType() == Void.TYPE) {
            return PromptoMethod.newConsumerReference(method, instance);
        }
        return PromptoMethod.newSupplierReference(method, instance);
    }

    private static Object newSupplierReference(Method method, Object instance) {
        BiFunction<Method, Object, Object> supplier = supplierProducers.get(method.getParameterCount());
        if (supplier == null) {
            throw new UnsupportedOperationException("newSupplierReference with " + method.getParameterCount() + " parameter(s)");
        }
        return supplier.apply(method, instance);
    }

    private static Object newConsumerReference(Method method, Object instance) {
        BiFunction<Method, Object, Object> consumer = consumerProducers.get(method.getParameterCount());
        if (consumer == null) {
            throw new UnsupportedOperationException("newConsumerReference with " + method.getParameterCount() + " parameter(s)");
        }
        return consumer.apply(method, instance);
    }

    private static Object safeInvoke(Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Runnable newRunnable(Method method, Object instance) {
        return () -> PromptoMethod.safeInvoke(method, instance, new Object[0]);
    }

    private static Consumer<Object> newConsumer(Method method, Object instance) {
        return a -> PromptoMethod.safeInvoke(method, instance, a);
    }

    private static Function<Object, Object> newFunction(Method method, Object instance) {
        return a -> PromptoMethod.safeInvoke(method, instance, a);
    }
}

