/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import prompto.intrinsic.PromptoEnum;

public abstract class PromptoNativeSymbol
implements PromptoEnum {
    public static List<PromptoNativeSymbol> getNativeSymbols(Class<?> klass) {
        ArrayList<PromptoNativeSymbol> list = new ArrayList<PromptoNativeSymbol>();
        for (Field field : klass.getDeclaredFields()) {
            if (!Character.isUpperCase(field.getName().charAt(0))) continue;
            list.add(PromptoNativeSymbol.nativeSymbolOf(field));
        }
        return list;
    }

    public static PromptoNativeSymbol nativeSymbolOf(Class<?> klass, String name) {
        try {
            Field field = klass.getDeclaredField(name);
            return PromptoNativeSymbol.nativeSymbolOf(field);
        }
        catch (IllegalArgumentException | NoSuchFieldException e) {
            return null;
        }
    }

    private static PromptoNativeSymbol nativeSymbolOf(final Field field) {
        return new PromptoNativeSymbol(){

            @Override
            public String getName() {
                return field.getName();
            }

            @Override
            public Object getValue() {
                try {
                    return field.get(null);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
        };
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object toDocument() {
        return this.getValue();
    }
}

