/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import prompto.intrinsic.IDocumentable;
import prompto.value.IMultiplyable;

public class PromptoPeriod
implements IMultiplyable,
IDocumentable {
    Period wrapped;

    public static PromptoPeriod parse(String text) {
        return new PromptoPeriod(Period.parse((String)text));
    }

    public PromptoPeriod(long duration) {
        this.wrapped = new Period(duration);
    }

    public PromptoPeriod(Period wrapped) {
        this.wrapped = wrapped;
    }

    public PromptoPeriod(long years, long months, long weeks, long days, long hours, long minutes, long seconds, long millis) {
        this.wrapped = new Period((int)years, (int)months, (int)weeks, (int)days, (int)hours, (int)minutes, (int)seconds, (int)millis);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PromptoPeriod && this.wrapped.equals((Object)((PromptoPeriod)obj).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public PromptoPeriod plus(PromptoPeriod value) {
        return new PromptoPeriod(this.wrapped.plus((ReadablePeriod)value.wrapped));
    }

    public PromptoPeriod minus(PromptoPeriod value) {
        return new PromptoPeriod(this.wrapped.minus((ReadablePeriod)value.wrapped));
    }

    public long getNativeYears() {
        return this.wrapped.getYears();
    }

    public long getNativeMonths() {
        return this.wrapped.getMonths();
    }

    public long getNativeWeeks() {
        return this.wrapped.getWeeks();
    }

    public long getNativeDays() {
        return this.wrapped.getDays();
    }

    public long getNativeHours() {
        return this.wrapped.getHours();
    }

    public long getNativeMinutes() {
        return this.wrapped.getMinutes();
    }

    public long getNativeSeconds() {
        return this.wrapped.getSeconds();
    }

    public long getNativeMillis() {
        return this.wrapped.getMillis();
    }

    public PromptoPeriod multiply(int count) {
        return new PromptoPeriod(this.getNativeYears() * (long)count, this.getNativeMonths() * (long)count, this.getNativeWeeks() * (long)count, this.getNativeDays() * (long)count, this.getNativeHours() * (long)count, this.getNativeMinutes() * (long)count, this.getNativeSeconds() * (long)count, this.getNativeMillis() * (long)count);
    }

    public PromptoPeriod negate() {
        return new PromptoPeriod(-this.getNativeYears(), -this.getNativeMonths(), -this.getNativeWeeks(), -this.getNativeDays(), -this.getNativeHours(), -this.getNativeMinutes(), -this.getNativeSeconds(), -this.getNativeMillis());
    }

    @Override
    public Object toDocument() {
        return this.toString();
    }
}

