/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import prompto.intrinsic.PromptoMethod;

public abstract class PromptoProxy {
    public static <T> T newProxy(final Object o, Class<T> klass) {
        return (T)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(o, args);
            }
        });
    }

    public static <T> T newProxy(final Object o, Class<T> klass, final String methodName, Class<?>[] parameterTypes) {
        final Class[] paramTypes = PromptoProxy.adjustParameterTypesForLambda(o.getClass(), parameterTypes);
        return (T)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                method = o.getClass().getMethod(methodName, paramTypes);
                return method.invoke(o, args);
            }
        });
    }

    private static Class<?>[] adjustParameterTypesForLambda(Class<? extends Object> klass, Class<?>[] parameterTypes) {
        if (klass.getName().startsWith(PromptoMethod.class.getName() + "$$Lambda$")) {
            Object[] objectTypes = new Class[parameterTypes.length];
            Arrays.fill(objectTypes, Object.class);
            return objectTypes;
        }
        return parameterTypes;
    }
}

