/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.Collection;
import java.util.Iterator;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoTime;

public abstract class PromptoRange<T>
implements IterableWithCounts<T> {
    protected T low;
    protected T high;

    public PromptoRange(T low, T high) {
        this.low = low;
        this.high = high;
    }

    public T getLow() {
        return this.low;
    }

    public T getHigh() {
        return this.high;
    }

    @Override
    public java.lang.Long getCount() {
        return this.getNativeCount();
    }

    @Override
    public java.lang.Long getTotalCount() {
        return this.getNativeCount();
    }

    @Override
    public abstract long getNativeCount();

    public abstract T getItem(long var1);

    public String toString() {
        return "[" + this.low.toString() + ".." + this.high.toString() + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof PromptoRange && this.low.equals(((PromptoRange)obj).low) && this.high.equals(((PromptoRange)obj).high);
    }

    public abstract PromptoRange<T> slice(long var1, long var3);

    protected long adjustLastSliceIndex(long last) {
        if (last >= 0L) {
            return last;
        }
        return this.getNativeCount() + 1L + last;
    }

    public abstract boolean contains(Object var1);

    public boolean containsAll(Collection<Object> items) {
        for (Object item : items) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Collection<Object> items) {
        for (Object item : items) {
            if (!this.contains(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            long index = 0L;
            long length = PromptoRange.this.getNativeCount();

            @Override
            public boolean hasNext() {
                return this.index < this.length;
            }

            @Override
            public T next() {
                return PromptoRange.this.getItem(++this.index);
            }
        };
    }

    public static class Time
    extends PromptoRange<PromptoTime> {
        public Time(PromptoTime low, PromptoTime high) {
            super(low, high);
        }

        @Override
        public PromptoTime getItem(long item) {
            PromptoTime result = ((PromptoTime)this.low).plusSeconds(item - 1L);
            if (result.isAfter((PromptoTime)this.high)) {
                throw new IndexOutOfBoundsException();
            }
            return result;
        }

        public Time slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new Time(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            return 1L + (((PromptoTime)this.high).getNativeMillisOfDay() - ((PromptoTime)this.low).getNativeMillisOfDay()) / 1000L;
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof PromptoTime)) {
                return false;
            }
            PromptoTime other = (PromptoTime)item;
            return other.compareTo((PromptoTime)this.low) >= 0 && ((PromptoTime)this.high).compareTo(other) >= 0;
        }
    }

    public static class Date
    extends PromptoRange<PromptoDate> {
        public Date(PromptoDate low, PromptoDate high) {
            super(low, high);
        }

        @Override
        public PromptoDate getItem(long item) {
            PromptoDate result = ((PromptoDate)this.low).plusDays(item - 1L);
            if (result.isAfter((PromptoDate)this.high)) {
                throw new IndexOutOfBoundsException();
            }
            return result;
        }

        public Date slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new Date(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            long h = ((PromptoDate)this.high).toJavaTime();
            long l = ((PromptoDate)this.low).toJavaTime();
            return 1L + (h - l) / 86400000L;
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof PromptoDate)) {
                return false;
            }
            PromptoDate other = (PromptoDate)item;
            return other.compareTo((PromptoDate)this.low) >= 0 && ((PromptoDate)this.high).compareTo(other) >= 0;
        }
    }

    public static class Long
    extends PromptoRange<java.lang.Long> {
        public Long(java.lang.Long low, java.lang.Long high) {
            super(low, high);
        }

        @Override
        public java.lang.Long getItem(long item) {
            long result = (java.lang.Long)this.low + item - 1L;
            if (result > (java.lang.Long)this.high) {
                throw new IndexOutOfBoundsException();
            }
            return result;
        }

        public Long slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new Long(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            return 1L + (java.lang.Long)this.high - (java.lang.Long)this.low;
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof java.lang.Long)) {
                return false;
            }
            java.lang.Long other = (java.lang.Long)item;
            return other.compareTo((java.lang.Long)this.low) >= 0 && ((java.lang.Long)this.high).compareTo(other) >= 0;
        }
    }

    public static class Character
    extends PromptoRange<java.lang.Character> {
        public Character(java.lang.Character low, java.lang.Character high) {
            super(low, high);
        }

        @Override
        public java.lang.Character getItem(long item) {
            char result = (char)((long)((java.lang.Character)this.low).charValue() + item - 1L);
            if (result > ((java.lang.Character)this.high).charValue()) {
                throw new IndexOutOfBoundsException();
            }
            return java.lang.Character.valueOf(result);
        }

        public Character slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new Character(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            return 1L + (long)((java.lang.Character)this.high).charValue() - (long)((java.lang.Character)this.low).charValue();
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof java.lang.Character)) {
                return false;
            }
            java.lang.Character other = (java.lang.Character)item;
            return other.compareTo((java.lang.Character)this.low) >= 0 && ((java.lang.Character)this.high).compareTo(other) >= 0;
        }
    }
}

