/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import prompto.compiler.CompilerUtils;
import prompto.compiler.PromptoClassLoader;
import prompto.declaration.CategoryDeclaration;
import prompto.error.NotStorableError;
import prompto.grammar.Identifier;
import prompto.intrinsic.IDocumentable;
import prompto.intrinsic.IMutable;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoEnum;
import prompto.intrinsic.PromptoException;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoStorableBase;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.store.DataStore;
import prompto.store.IStorable;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.InvalidValueError;

public abstract class PromptoRoot
extends PromptoStorableBase
implements IMutable,
IDocumentable {
    protected IStorable storable;
    protected boolean mutable;
    private static Set<String> hiddenFields = new HashSet<String>(Arrays.asList("category", "dbId", "storable", "mutable", "hiddenFields"));

    public static PromptoRoot newInstance(IStored stored) {
        if (stored == null) {
            return null;
        }
        try {
            Object list = stored.getData("category");
            String name = (String)((PromptoList)list).getLast();
            String concreteName = CompilerUtils.getCategoryConcreteType(name).getTypeName();
            PromptoClassLoader loader = PromptoClassLoader.getInstance();
            if (loader == null) {
                throw new UnsupportedOperationException("newPromptoRoot can only be used in compiled mode!");
            }
            Class<?> klass = Class.forName(concreteName, true, loader);
            Constructor<?> cons = klass.getConstructor(IStored.class);
            Object instance = cons.newInstance(stored);
            return (PromptoRoot)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PromptoRoot newInstanceFromDbIdRef(Object value) {
        if (value instanceof PromptoRoot) {
            return (PromptoRoot)value;
        }
        if (DataStore.getInstance().getDbIdClass().isInstance(value)) {
            value = DataStore.getInstance().fetchUnique(value);
        }
        if (value instanceof IStored) {
            return PromptoRoot.newInstance((IStored)value);
        }
        return (PromptoRoot)value;
    }

    public static IterableWithCounts<PromptoRoot> newIterable(final IStoredIterable iterable) {
        return new IterableWithCounts<PromptoRoot>(){

            @Override
            public Long getCount() {
                return iterable.count();
            }

            @Override
            public Long getTotalCount() {
                return iterable.totalCount();
            }

            @Override
            public Iterator<PromptoRoot> iterator() {
                return new Iterator<PromptoRoot>(){
                    Iterator<IStored> iterator;
                    {
                        this.iterator = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public PromptoRoot next() {
                        return PromptoRoot.newInstance(this.iterator.next());
                    }
                };
            }
        };
    }

    public static Object getStorableData(Object value) {
        if (value instanceof PromptoEnum) {
            return ((PromptoEnum)value).getName();
        }
        if (value instanceof PromptoRoot) {
            return ((PromptoRoot)value).getStorableData();
        }
        return null;
    }

    public static <T extends PromptoRoot> T convertObjectToExact(Object o, Class<T> klass) {
        if (o == null) {
            return null;
        }
        if (klass.isInstance(o)) {
            return (T)((PromptoRoot)o);
        }
        throw new InvalidValueError("Expected a " + klass.getSimpleName() + ", got " + o.getClass().getSimpleName());
    }

    protected PromptoRoot() {
    }

    protected PromptoRoot(IStored stored) {
        if (stored != null) {
            this.dbId = stored.getDbId();
        }
    }

    public CategoryDeclaration getCategory() {
        String name = this.getCategoryName();
        Context context = ApplicationContext.get();
        return context.getRegisteredDeclaration(CategoryDeclaration.class, new Identifier(name));
    }

    private String getCategoryName() {
        String[] parts = this.getClass().getName().split("%");
        return parts[parts.length - 1];
    }

    public IStorable getStorable() {
        return this.storable;
    }

    public final Object getStorableData() {
        if (this.storable == null) {
            throw new NotStorableError();
        }
        return this.getOrCreateDbId();
    }

    private Object getOrCreateDbId() throws NotStorableError {
        Object dbId = this.getDbId();
        if (dbId == null) {
            dbId = this.storable.getOrCreateDbId();
            this.setDbId(dbId);
        }
        return dbId;
    }

    protected final void setStorable(String name, Object value) {
        if (this.storable != null) {
            this.storable.setData(name, value);
        }
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public void checkMutable() {
        if (!this.mutable) {
            PromptoException.throwEnumeratedException("NOT_MUTABLE");
        }
    }

    @Override
    public void checkImmutable() {
        if (this.mutable) {
            PromptoException.throwEnumeratedException("NOT_MUTABLE");
        }
    }

    @Override
    public PromptoRoot toMutable() {
        try {
            Constructor<?> cons = this.getClass().getConstructor(new Class[0]);
            PromptoRoot instance = (PromptoRoot)cons.newInstance(new Object[0]);
            instance.mutable = true;
            List<Field> fields = this.collectFields();
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(this);
                field.set(instance, value);
            }
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        List<Field> fields = this.collectFields();
        fields.forEach(field -> {
            sb.append(field.getName());
            sb.append(':');
            sb.append(String.valueOf(this.getFieldValue((Field)field)));
            sb.append(", ");
        });
        if (sb.length() > 1) {
            sb.setLength(sb.length() - ", ".length());
        }
        sb.append('}');
        return sb.toString();
    }

    protected Object getFieldValue(Field field) {
        boolean accessible = field.isAccessible();
        return accessible ? this.getAccessibleFieldValue(field) : this.getInaccessibleFieldValue(field);
    }

    private Object getInaccessibleFieldValue(Field field) {
        try {
            field.setAccessible(true);
            Object object = this.getAccessibleFieldValue(field);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    private Object getAccessibleFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception e) {
            return "<unreadable>";
        }
    }

    private List<Field> collectFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        this.collectFields(list, this.getClass());
        return list;
    }

    private void collectFields(List<Field> list, Class<?> klass) {
        if (Object.class == klass) {
            return;
        }
        this.collectFields(list, klass.getSuperclass());
        list.addAll(Arrays.asList(klass.getDeclaredFields()).stream().filter(f -> !hiddenFields.contains(f.getName())).collect(Collectors.toList()));
    }

    public void collectStorables(Consumer<IStorable> collector) {
        if (this.storable != null && this.storable.isDirty()) {
            this.getOrCreateDbId();
            collector.accept(this.storable);
        }
    }

    @Override
    public PromptoDocument<String, Object> toDocument() {
        PromptoDocument<String, Object> doc = new PromptoDocument<String, Object>();
        List<Field> fields = this.collectFields();
        fields.forEach(field -> {
            Object value = this.getFieldValue((Field)field);
            if (value instanceof IDocumentable) {
                value = ((IDocumentable)value).toDocument();
            }
            doc.put(field.getName(), value);
        });
        return doc;
    }
}

