/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import prompto.intrinsic.Filterable;
import prompto.intrinsic.PromptoList;

public class PromptoSet<V>
extends HashSet<V>
implements Filterable<PromptoSet<V>, V> {
    public PromptoSet() {
    }

    public PromptoSet(Collection<V> items) {
        super(items);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        this.forEach(i -> {
            sb.append(i.toString());
            sb.append(", ");
        });
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('>');
        return sb.toString();
    }

    public Long getCount() {
        return this.size();
    }

    public long getNativeCount() {
        return this.size();
    }

    public PromptoList<V> sort(boolean descending) {
        Comparator cmp = descending ? (o1, o2) -> ((Comparable)o2).compareTo(o1) : (o1, o2) -> ((Comparable)o1).compareTo(o2);
        TreeSet sorted = new TreeSet(cmp);
        sorted.addAll(this);
        return new PromptoList(sorted, false);
    }

    public PromptoList<? extends V> sortUsing(Comparator<? extends V> cmp) {
        PromptoList sorted = new PromptoList(this, false);
        sorted.sort(cmp);
        return sorted;
    }

    public boolean containsAny(Collection<Object> items) {
        for (Object item : items) {
            if (!this.contains(item)) continue;
            return true;
        }
        return false;
    }

    public Object get(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        for (Object item : this) {
            if (index == 0) {
                return item;
            }
            --index;
        }
        throw new UnsupportedOperationException("Should never get there!");
    }

    @Override
    public PromptoSet<V> filter(Predicate<V> p) {
        PromptoSet filtered = new PromptoSet();
        this.forEach(v -> {
            if (p.test(v)) {
                filtered.add(v);
            }
        });
        return filtered;
    }

    public String join(String delimiter) {
        return this.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }
}

