/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoRoot;
import prompto.runtime.Context;
import prompto.store.DataStore;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.value.IInstance;
import prompto.value.IIterable;
import prompto.value.IValue;
import prompto.value.NullValue;

public class PromptoStoreQuery {
    Set<Object> deletables = new HashSet<Object>();
    Map<Object, IStorable> storables = new HashMap<Object, IStorable>();

    public void execute() {
        if (this.deletables.isEmpty()) {
            this.deletables = null;
        }
        if (this.storables.isEmpty()) {
            this.storables = null;
        }
        if (this.deletables != null || this.storables != null) {
            IStore store = DataStore.getInstance();
            try {
                store.store(this.deletables, this.storables == null ? null : this.storables.values());
                if (this.storables != null) {
                    this.storables.values().forEach(IStorable::clear);
                }
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(Context context, IValue value) {
        if (value == NullValue.instance()) {
            return;
        }
        if (value instanceof IInstance) {
            try {
                IValue dbId = ((IInstance)value).getMember(context, new Identifier("dbId"), false);
                if (dbId == null) return;
                this.deletables.add(dbId.getStorableData());
                return;
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof IIterable) {
            ((IIterable)value).getIterable(context).forEach(item -> this.delete(context, (IValue)item));
            return;
        } else {
            if (!(value instanceof Iterator)) throw new UnsupportedOperationException("Can't delete " + value.getClass());
            Iterator iter = (Iterator)((Object)value);
            while (iter.hasNext()) {
                this.delete(context, (IValue)iter.next());
            }
        }
    }

    public void store(Context context, IValue value) {
        if (value == NullValue.instance()) {
            return;
        }
        if (value instanceof IInstance) {
            try {
                ((IInstance)value).collectStorables(s -> this.storables.put(s.getOrCreateDbId(), (IStorable)s));
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof IIterable) {
            ((IIterable)value).getIterable(context).forEach(item -> this.store(context, (IValue)item));
        } else if (value instanceof Iterator) {
            Iterator iter = (Iterator)((Object)value);
            while (iter.hasNext()) {
                this.store(iter.next());
            }
        } else {
            throw new UnsupportedOperationException("Can't store " + value.getClass());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof PromptoRoot) {
            try {
                Object dbId = ((PromptoRoot)value).getDbId();
                if (dbId == null) return;
                this.deletables.add(dbId);
                return;
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof Iterable) {
            ((Iterable)value).forEach(item -> this.delete(item));
            return;
        } else {
            if (!(value instanceof Iterator)) throw new UnsupportedOperationException("Can't delete " + value.getClass());
            Iterator iter = (Iterator)value;
            while (iter.hasNext()) {
                this.delete(iter.next());
            }
        }
    }

    public void store(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof PromptoRoot) {
            ((PromptoRoot)value).collectStorables(s -> this.storables.put(s.getOrCreateDbId(), (IStorable)s));
        } else if (value instanceof Iterable) {
            ((Iterable)value).forEach(item -> this.store(item));
        } else if (value instanceof Iterator) {
            Iterator iter = (Iterator)value;
            while (iter.hasNext()) {
                this.store(iter.next());
            }
        } else {
            throw new UnsupportedOperationException("Can't delete " + value.getClass());
        }
    }
}

