/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import prompto.intrinsic.IDocumentable;
import prompto.intrinsic.PromptoPeriod;

public class PromptoTime
implements Comparable<PromptoTime>,
IDocumentable {
    private LocalTime wrapped;

    public static PromptoTime parse(String text) {
        return new PromptoTime(LocalTime.parse((String)text));
    }

    public static PromptoTime fromMillisOfDay(long utc) {
        return new PromptoTime(LocalTime.fromMillisOfDay((long)utc));
    }

    public PromptoTime(LocalTime wrapped) {
        this.wrapped = wrapped;
    }

    public PromptoTime(int hour, int minute, int second, int millis) {
        this.wrapped = new LocalTime(hour, minute, second, millis);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PromptoTime && this.wrapped.equals((Object)((PromptoTime)obj).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    @Override
    public int compareTo(PromptoTime o) {
        return this.wrapped.compareTo((ReadablePartial)o.wrapped);
    }

    public Long getHour() {
        return this.wrapped.getHourOfDay();
    }

    public Long getMinute() {
        return this.wrapped.getMinuteOfHour();
    }

    public Long getSecond() {
        return this.wrapped.getSecondOfMinute();
    }

    public Long getMillisecond() {
        return this.wrapped.getMillisOfSecond();
    }

    public long getNativeHour() {
        return this.wrapped.getHourOfDay();
    }

    public long getNativeMinute() {
        return this.wrapped.getMinuteOfHour();
    }

    public long getNativeSecond() {
        return this.wrapped.getSecondOfMinute();
    }

    public long getNativeMillis() {
        return this.wrapped.getMillisOfSecond();
    }

    public long getNativeMillisOfDay() {
        return this.wrapped.getMillisOfDay();
    }

    public boolean isAfter(PromptoTime value) {
        return this.wrapped.isAfter((ReadablePartial)value.wrapped);
    }

    public PromptoTime plus(PromptoPeriod period) {
        return new PromptoTime(this.wrapped.plus((ReadablePeriod)period.wrapped));
    }

    public PromptoTime minus(PromptoPeriod period) {
        return new PromptoTime(this.wrapped.minus((ReadablePeriod)period.wrapped));
    }

    public String format(String formatString) {
        return this.wrapped.toString(formatString);
    }

    public boolean isEqual(PromptoTime actual) {
        return this.wrapped.isEqual((ReadablePartial)actual.wrapped);
    }

    public PromptoTime plusSeconds(long seconds) {
        return new PromptoTime(this.wrapped.plusSeconds((int)seconds));
    }

    public PromptoPeriod minus(PromptoTime other) {
        return new PromptoPeriod(0L, 0L, 0L, 0L, this.getNativeHour() - other.getNativeHour(), this.getNativeMinute() - other.getNativeMinute(), this.getNativeSecond() - other.getNativeSecond(), this.getNativeMillis() - other.getNativeMillis());
    }

    @Override
    public Object toDocument() {
        return this.toString();
    }
}

