/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import prompto.intrinsic.PromptoException;

public class PromptoTuple<V>
extends ArrayList<V> {
    boolean mutable;

    public PromptoTuple(boolean mutable) {
        this.mutable = mutable;
    }

    public PromptoTuple(Collection<? extends V> items, boolean mutable) {
        super(items);
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        this.forEach((? super E i) -> {
            sb.append(i.toString());
            sb.append(", ");
        });
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    public Long getCount() {
        return this.size();
    }

    public long getNativeCount() {
        return this.size();
    }

    public PromptoTuple<V> slice(long first, long last) {
        if (last < 0L) {
            last = (long)(this.size() + 1) + last;
        }
        return new PromptoTuple(this.subList((int)(first - 1L), (int)last), false);
    }

    public boolean containsAny(Collection<Object> items) {
        for (Object item : items) {
            if (!this.contains(item)) continue;
            return true;
        }
        return false;
    }

    public int compareTo(PromptoTuple<?> other, List<Boolean> directions) {
        boolean descending;
        Iterator<Boolean> iterDirs = directions.iterator();
        Iterator iterThis = this.iterator();
        Iterator iterOther = other.iterator();
        while (iterThis.hasNext() && iterOther.hasNext()) {
            descending = iterDirs.hasNext() ? iterDirs.next() : false;
            Object thisVal = iterThis.next();
            Object otherVal = iterOther.next();
            if (thisVal == null && otherVal == null) continue;
            if (thisVal == null) {
                return descending ? 1 : -1;
            }
            if (otherVal == null) {
                return descending ? -1 : 1;
            }
            if (!(thisVal instanceof Comparable) || !thisVal.getClass().isInstance(otherVal)) {
                return 0;
            }
            int cmp = ((Comparable)thisVal).compareTo(otherVal);
            if (cmp == 0) continue;
            return descending ? -cmp : cmp;
        }
        boolean bl = descending = iterDirs.hasNext() ? iterDirs.next() : false;
        if (iterThis.hasNext()) {
            return descending ? -1 : 1;
        }
        if (iterOther.hasNext()) {
            return descending ? 1 : -1;
        }
        return 0;
    }

    @Override
    public V set(int index, V element) {
        if (!this.mutable) {
            PromptoException.throwEnumeratedException("NOT_MUTABLE");
        }
        return super.set(index, element);
    }

    public String join(String delimiter) {
        return this.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }
}

