/*
 * Decompiled with CFR 0.152.
 */
package prompto.intrinsic;

import java.security.InvalidParameterException;

public class PromptoVersion
implements Comparable<PromptoVersion> {
    public static final PromptoVersion LATEST = PromptoVersion.parse("-1.-1.-1");
    int major;
    int minor;
    int fix;

    public static PromptoVersion parse(String version) {
        String[] parts;
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        if ((parts = version.split("\\.")).length < 3) {
            throw new InvalidParameterException("Version must be like 1.2.3!");
        }
        PromptoVersion v = new PromptoVersion();
        v.major = Integer.parseInt(parts[0]);
        v.minor = Integer.parseInt(parts[1]);
        v.fix = Integer.parseInt(parts[2]);
        return v;
    }

    public static PromptoVersion parse(int version) {
        PromptoVersion v = new PromptoVersion();
        v.major = version >> 24 & 0xFF;
        v.minor = version >> 16 & 0xFF;
        v.fix = version & 0xFFFF;
        return v;
    }

    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.fix;
    }

    public int asInt() {
        return this.major << 24 & 0xFF000000 | this.minor << 16 & 0xFF0000 | this.fix & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PromptoVersion) {
            return this.asInt() == ((PromptoVersion)obj).asInt();
        }
        return false;
    }

    @Override
    public int compareTo(PromptoVersion o) {
        return Integer.compare(this.asInt(), o.asInt());
    }
}

