/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.Type;
import prompto.compiler.ByteOperand;
import prompto.compiler.IntConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.java.JavaClassType;
import prompto.java.JavaLiteral;
import prompto.runtime.Context;
import prompto.type.IType;

public class JavaCharacterLiteral
extends JavaLiteral {
    Character value;

    public JavaCharacterLiteral(String text) {
        super(text);
        this.value = Character.valueOf(text.charAt(1));
    }

    public String toString() {
        return "'" + this.value + "'";
    }

    @Override
    public Object interpret(Context context) {
        return this.value;
    }

    @Override
    public IType check(Context context) {
        return new JavaClassType((Type)((Object)Character.class));
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method) {
        if ((this.value.charValue() & 0xFFFFFF00) == 0) {
            method.addInstruction(Opcode.BIPUSH, new ByteOperand((byte)this.value.charValue()));
        } else if ((this.value.charValue() & 0xFFFF0000) == 0) {
            method.addInstruction(Opcode.SIPUSH, new ShortOperand((short)this.value.charValue()));
        } else {
            method.addInstruction(Opcode.LDC_W, new IntConstant(this.value.charValue()));
        }
        return new ResultInfo(Character.TYPE, new ResultInfo.Flag[0]);
    }
}

