/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import prompto.declaration.AnyNativeCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoSet;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.type.AnyType;
import prompto.type.BaseType;
import prompto.type.ContainerType;
import prompto.type.DictType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.IteratorType;
import prompto.type.ListType;
import prompto.type.SetType;
import prompto.type.TextType;
import prompto.utils.TypeUtils;
import prompto.value.BinaryValue;
import prompto.value.DictionaryValue;
import prompto.value.DocumentValue;
import prompto.value.IValue;
import prompto.value.IteratorValue;
import prompto.value.ListValue;
import prompto.value.NativeInstance;
import prompto.value.SetValue;
import prompto.value.TextValue;

public class JavaClassType
extends BaseType {
    Type type;

    public JavaClassType(Type type) {
        super(Family.CLASS);
        this.type = type;
    }

    @Override
    public Type getJavaType(Context context) {
        return JavaClassType.toJavaClass(this.type);
    }

    private static Class<?> toJavaClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return JavaClassType.toJavaClass(((ParameterizedType)type).getRawType());
        }
        throw new RuntimeException("Unsupported:" + type.getClass());
    }

    public IType convertJavaClassToPromptoType(Context context, IType returnType) {
        return JavaClassType.convertJavaClassToPromptoType(context, this.type, returnType);
    }

    private static IType convertJavaClassToPromptoType(Context context, Type type, IType returnType) {
        IType result = TypeUtils.typeToIType(type);
        if (result != null) {
            return result;
        }
        result = JavaClassType.convertParameterizedType(context, type);
        if (result != null) {
            return result;
        }
        NativeCategoryDeclaration decl = context.getNativeBinding(type);
        if (decl != null) {
            return decl.getType(context);
        }
        if (returnType == AnyType.instance()) {
            return returnType;
        }
        return null;
    }

    private static IType convertParameterizedType(Context context, Type type) {
        ParameterizedType ptype;
        Type rawType;
        if (type instanceof ParameterizedType && (rawType = (ptype = (ParameterizedType)type).getRawType()) instanceof Class) {
            if (PromptoDocument.class.isAssignableFrom((Class)rawType)) {
                return DocumentType.instance();
            }
            if (List.class.isAssignableFrom((Class)rawType)) {
                Type elemType = ptype.getActualTypeArguments()[0];
                IType itemType = JavaClassType.convertJavaClassToPromptoType(context, elemType, null);
                return new ListType(itemType);
            }
            if (Set.class.isAssignableFrom((Class)rawType)) {
                Type elemType = ptype.getActualTypeArguments()[0];
                IType itemType = JavaClassType.convertJavaClassToPromptoType(context, elemType, null);
                return new SetType(itemType);
            }
            if (Iterator.class.isAssignableFrom((Class)rawType)) {
                Type elemType = ptype.getActualTypeArguments()[0];
                IType itemType = JavaClassType.convertJavaClassToPromptoType(context, elemType, null);
                return new IteratorType(itemType);
            }
            if (Map.class.isAssignableFrom((Class)rawType)) {
                Type elemType = ptype.getActualTypeArguments()[1];
                IType itemType = JavaClassType.convertJavaClassToPromptoType(context, elemType, null);
                return new DictType(itemType);
            }
        }
        return null;
    }

    private static Type nthArgTypeFromParameterizedType(Type type, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return ptype.getActualTypeArguments()[index];
        }
        return Object.class;
    }

    public IValue convertJavaValueToPromptoValue(Context context, Object value, IType returnType) {
        return JavaClassType.convertJavaValueToPromptoValue(context, value, this.type, returnType);
    }

    public static IValue convertJavaValueToPromptoValue(Context context, Object value, Type type, IType returnType) {
        IValue val = JavaClassType.convertIValue(value);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertNative(context, value, type);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertCategory(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertDocument(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertList(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertSet(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertDict(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertIterator(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        val = JavaClassType.convertBinary(context, value, type, returnType);
        if (val != null) {
            return val;
        }
        if (returnType == AnyType.instance()) {
            return new NativeInstance(AnyNativeCategoryDeclaration.getInstance(), value);
        }
        throw new InternalError("Unable to convert:" + value.getClass().getSimpleName());
    }

    private static IValue convertIValue(Object value) {
        return value instanceof IValue ? (IValue)value : null;
    }

    private static IValue convertNative(Context context, Object value, Type type) {
        IType itype = TypeUtils.typeToIType(type);
        return itype != null ? itype.convertJavaValueToIValue(context, value) : null;
    }

    private static IValue convertCategory(Context context, Object value, Type type, IType returnType) {
        context.getRegisteredDeclaration(IDeclaration.class, returnType.getTypeNameId());
        NativeCategoryDeclaration decl = context.getNativeBinding(type);
        return decl != null ? new NativeInstance(decl, value) : null;
    }

    private static IValue convertDocument(Context context, Object value, Type type, IType returnType) {
        if (value instanceof PromptoDocument && (returnType == DocumentType.instance() || returnType == AnyType.instance())) {
            return new DocumentValue(context, (PromptoDocument)value, true);
        }
        return null;
    }

    private static IValue convertList(Context context, Object value, Type type, IType returnType) {
        if (value instanceof List && (returnType instanceof ListType || returnType == AnyType.instance())) {
            Type elemType = JavaClassType.nthArgTypeFromParameterizedType(type, 0);
            AnyType itemType = returnType instanceof ListType ? ((ContainerType)returnType).getItemType() : AnyType.instance();
            PromptoList<IValue> list = new PromptoList<IValue>(false);
            for (Object obj : (List)value) {
                IValue val = JavaClassType.convertJavaValueToPromptoValue(context, obj, elemType, itemType);
                list.add(val);
            }
            return new ListValue((IType)itemType, list);
        }
        return null;
    }

    private static IValue convertSet(Context context, Object value, Type type, IType returnType) {
        if (!(value instanceof Set) || !(returnType instanceof SetType)) {
            return null;
        }
        Type elemType = JavaClassType.nthArgTypeFromParameterizedType(type, 0);
        IType itemType = ((SetType)returnType).getItemType();
        PromptoSet<IValue> set = new PromptoSet<IValue>();
        for (Object obj : (Set)value) {
            IValue val = JavaClassType.convertJavaValueToPromptoValue(context, obj, elemType, itemType);
            set.add(val);
        }
        return new SetValue(itemType, set);
    }

    private static IValue convertDict(Context context, Object value, Type type, IType returnType) {
        if (!(value instanceof Map) || !(returnType instanceof DictType)) {
            return null;
        }
        Type keyType = JavaClassType.nthArgTypeFromParameterizedType(type, 0);
        Type elemType = JavaClassType.nthArgTypeFromParameterizedType(type, 1);
        IType itemType = ((DictType)returnType).getItemType();
        PromptoDict<TextValue, IValue> dict = new PromptoDict<TextValue, IValue>(true);
        for (Object obj : ((Map)value).keySet()) {
            Object val = ((Map)value).get(obj);
            TextValue key = (TextValue)JavaClassType.convertJavaValueToPromptoValue(context, obj, keyType, TextType.instance());
            IValue ivalue = JavaClassType.convertJavaValueToPromptoValue(context, val, elemType, itemType);
            dict.put(key, ivalue);
        }
        dict.setMutable(false);
        return new DictionaryValue(itemType, dict);
    }

    private static IValue convertIterator(final Context context, Object value, Type type, IType returnType) {
        if (!(value instanceof Iterator) || !(returnType instanceof IteratorType)) {
            return null;
        }
        final Iterator source = (Iterator)value;
        final Type elemType = JavaClassType.nthArgTypeFromParameterizedType(type, 0);
        final IType itemType = ((IteratorType)returnType).getItemType();
        Iterator<IValue> convertingIterator = new Iterator<IValue>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public IValue next() {
                Object val = source.next();
                return JavaClassType.convertJavaValueToPromptoValue(context, val, elemType, itemType);
            }
        };
        return new IteratorValue(itemType, convertingIterator);
    }

    private static IValue convertBinary(Context context, Object value, Type type, IType returnType) {
        if (value instanceof PromptoBinary) {
            return BinaryValue.newInstance((PromptoBinary)value);
        }
        return null;
    }

    @Override
    public void checkUnique(Context context) {
    }

    @Override
    public void checkExists(Context context) {
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return false;
    }

    @Override
    public boolean isMoreSpecificThan(Context context, IType other) {
        return true;
    }
}

