/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.Type;
import prompto.compiler.DoubleConstant;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.java.JavaClassType;
import prompto.java.JavaLiteral;
import prompto.runtime.Context;
import prompto.type.IType;

public class JavaDecimalLiteral
extends JavaLiteral {
    Double value;

    public JavaDecimalLiteral(String text) {
        super(text);
        this.value = Double.valueOf(text);
    }

    @Override
    public Double interpret(Context context) {
        return this.value;
    }

    @Override
    public IType check(Context context) {
        return new JavaClassType((Type)((Object)Double.class));
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method) {
        if (this.value == 0.0) {
            method.addInstruction(Opcode.DCONST_0, new IOperand[0]);
        } else if (this.value == 1.0) {
            method.addInstruction(Opcode.DCONST_1, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LDC2_W, new DoubleConstant(this.value));
        }
        return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
    }
}

