/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.FieldConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.java.JavaClassType;
import prompto.java.JavaExpression;
import prompto.java.JavaIdentifierProcessor;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.utils.CodeWriter;

public class JavaIdentifierExpression
extends Section
implements JavaExpression {
    JavaIdentifierExpression parent = null;
    String name;
    boolean isChildClass = false;
    private static ClassLoader addOnsClassLoader;

    public static JavaIdentifierExpression parse(String ids) {
        String[] parts = ids.split("\\.");
        JavaIdentifierExpression result = null;
        for (String part : parts) {
            result = new JavaIdentifierExpression(result, part);
        }
        return result;
    }

    public JavaIdentifierExpression(String name) {
        this.name = name;
    }

    public JavaIdentifierExpression(JavaIdentifierExpression parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public JavaIdentifierExpression(JavaIdentifierExpression parent, String name, boolean isChildClass) {
        this.parent = parent;
        this.name = name;
        this.isChildClass = isChildClass;
    }

    public JavaIdentifierExpression getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.parent != null) {
            this.parent.toDialect(writer);
            writer.append(this.isChildClass ? (char)'$' : '.');
        }
        writer.append(this.name);
    }

    public String toString() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString() + (this.isChildClass ? (char)'$' : '.') + this.name;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method) {
        if (this.parent == null) {
            return this.compile_root(context, method);
        }
        return this.compile_child(context, method);
    }

    private ResultInfo compile_root(Context context, MethodInfo method) {
        ResultInfo info = this.compile_prompto(context, method);
        if (info != null) {
            return info;
        }
        info = this.compile_instance(context, method);
        if (info != null) {
            return info;
        }
        return this.compile_class(context, method);
    }

    private ResultInfo compile_prompto(Context context, MethodInfo method) {
        JavaIdentifierProcessor processor = JavaIdentifierProcessor.processors.get(this.name);
        if (processor == null) {
            return null;
        }
        return processor.compile(context, method);
    }

    private ResultInfo compile_instance(Context context, MethodInfo method) {
        INamed named = context.getRegisteredValue(INamed.class, new Identifier(this.name));
        if (named == null) {
            return null;
        }
        StackLocal local = method.getRegisteredLocal(this.name);
        ClassConstant downcastTo = null;
        if (local instanceof StackLocal.ObjectLocal) {
            downcastTo = ((StackLocal.ObjectLocal)local).getDowncastTo();
        }
        ResultInfo info = CompilerUtils.compileALOAD(method, local);
        if (downcastTo == null) {
            return info;
        }
        method.addInstruction(Opcode.CHECKCAST, downcastTo);
        return new ResultInfo(downcastTo.getType(), new ResultInfo.Flag[0]);
    }

    private ResultInfo compile_child(Context context, MethodInfo method) {
        ResultInfo info = this.parent.compile(context, method);
        if (info != null) {
            return this.compile_field(context, method, info);
        }
        return this.compile_class(context, method);
    }

    private ResultInfo compile_field(Context context, MethodInfo method, ResultInfo info) {
        try {
            Class klass = (Class)info.getType();
            Field field = klass.getField(this.name);
            FieldConstant oper = new FieldConstant(info.getType(), this.name, field.getType());
            if (info.isStatic()) {
                method.addInstruction(Opcode.GETSTATIC, oper);
            } else {
                method.addInstruction(Opcode.GETFIELD, oper);
            }
            return new ResultInfo(field.getType(), new ResultInfo.Flag[0]);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private ResultInfo compile_class(Context context, MethodInfo method) {
        String fullName = this.toString();
        try {
            Class<?> klass = addOnsClassLoader == null ? Class.forName(fullName) : addOnsClassLoader.loadClass(fullName);
            return new ResultInfo(klass, ResultInfo.Flag.STATIC);
        }
        catch (ClassNotFoundException e1) {
            if (this.parent == null) {
                try {
                    fullName = "java.lang." + this.name;
                    return new ResultInfo(Class.forName(fullName), ResultInfo.Flag.STATIC);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Override
    public Object interpret(Context context) throws PromptoError {
        if (this.parent == null) {
            return this.interpret_root(context);
        }
        return this.interpret_child(context);
    }

    Object interpret_root(Context context) throws PromptoError {
        Object o = this.interpret_prompto(context);
        if (o != null) {
            return o;
        }
        o = this.interpret_instance(context);
        if (o != null) {
            return o;
        }
        return this.interpret_class();
    }

    private Object interpret_prompto(Context context) {
        JavaIdentifierProcessor processor = JavaIdentifierProcessor.processors.get(this.name);
        if (processor == null) {
            return null;
        }
        return processor.interpret(context);
    }

    Object interpret_instance(Context context) throws PromptoError {
        try {
            return context.getValue(new Identifier(this.name));
        }
        catch (PromptoError e) {
            return null;
        }
    }

    public Class<?> interpret_class() {
        String fullName = this.toString();
        try {
            return addOnsClassLoader == null ? Class.forName(fullName) : addOnsClassLoader.loadClass(fullName);
        }
        catch (ClassNotFoundException e1) {
            if (this.parent == null) {
                try {
                    fullName = "java.lang." + this.name;
                    return Class.forName(fullName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    Object interpret_child(Context context) throws PromptoError {
        Object o = this.parent.interpret(context);
        if (o != null) {
            return this.interpret_field(o);
        }
        return this.interpret_class();
    }

    Object interpret_field(Object o) {
        Class<?> klass = null;
        if (o instanceof Class) {
            klass = (Class<?>)o;
            o = null;
        } else {
            klass = o.getClass();
        }
        try {
            Field field = klass.getField(this.name);
            return field.get(o);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            return null;
        }
    }

    @Override
    public IType check(Context context) {
        if (this.parent == null) {
            return this.check_root(context);
        }
        return this.check_child(context);
    }

    IType check_root(Context context) {
        IType t = this.check_prompto(context);
        if (t != null) {
            return t;
        }
        t = this.check_instance(context);
        if (t != null) {
            return t;
        }
        return this.check_class();
    }

    private IType check_prompto(Context context) {
        JavaIdentifierProcessor processor = JavaIdentifierProcessor.processors.get(this.name);
        if (processor == null) {
            return null;
        }
        return processor.check(context);
    }

    IType check_instance(Context context) {
        INamed named = context.getRegisteredValue(INamed.class, new Identifier(this.name));
        if (named == null) {
            return null;
        }
        try {
            return named.getType(context);
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    public static void registerAddOns(URL[] addOnURLs, ClassLoader parent) {
        if (addOnURLs != null && addOnURLs.length > 0) {
            addOnsClassLoader = new URLClassLoader(addOnURLs, parent);
        }
    }

    IType check_class() {
        String fullName = this.toString();
        try {
            Class<?> klass = addOnsClassLoader == null ? Class.forName(fullName) : addOnsClassLoader.loadClass(fullName);
            return new JavaClassType(klass);
        }
        catch (ClassNotFoundException e1) {
            if (this.parent == null) {
                try {
                    fullName = "java.lang." + this.name;
                    Class<?> klass = Class.forName(fullName);
                    return new JavaClassType(klass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    IType check_child(Context context) {
        IType t = this.parent.check(context);
        if (t != null) {
            return this.check_field(context, t);
        }
        return this.check_class();
    }

    IType check_field(Context context, IType t) {
        if (!(t instanceof JavaClassType)) {
            return null;
        }
        Type klass = t.getJavaType(context);
        if (klass instanceof Class) {
            try {
                Field field = ((Class)klass).getField(this.name);
                return new JavaClassType(field.getType());
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }
}

