/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.PromptoClassLoader;
import prompto.compiler.ResultInfo;
import prompto.java.JavaClassType;
import prompto.runtime.Context;
import prompto.type.IType;

public abstract class JavaIdentifierProcessor {
    public static Map<String, JavaIdentifierProcessor> processors = new HashMap<String, JavaIdentifierProcessor>();

    public abstract IType check(Context var1);

    public abstract Object interpret(Context var1);

    public abstract ResultInfo compile(Context var1, MethodInfo var2);

    static {
        processors.put("$context", new ContextIdentifierProcessor());
    }

    static class ContextIdentifierProcessor
    extends JavaIdentifierProcessor {
        ContextIdentifierProcessor() {
        }

        @Override
        public IType check(Context context) {
            return new JavaClassType(context.getClass());
        }

        @Override
        public Object interpret(Context context) {
            return context;
        }

        @Override
        public ResultInfo compile(Context context, MethodInfo method) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoClassLoader.class), "getInstance", new Type[]{PromptoClassLoader.class});
            method.addInstruction(Opcode.INVOKESTATIC, m);
            m = new MethodConstant((Type)((Object)PromptoClassLoader.class), "getContext", new Type[]{Context.class});
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            return new ResultInfo((Type)((Object)Context.class), new ResultInfo.Flag[0]);
        }
    }
}

